/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import java.util.Observer;

class viewCanvas
extends Canvas
implements Observer,
MouseMotionListener {
    public static int width = 240;
    public static int height = 180;
    OffScreen offscreen;
    Film film;
    int nFrame;
    int xs;
    int ys;
    int x0;
    int x1;
    int y0;
    int y1;
    int xc;
    int yc;
    double kSize = 1.0;
    int camX;
    int camY;
    int camW;
    int camH;
    boolean adjust = false;
    boolean adjustCenter = false;

    public viewCanvas(Film film) {
        this.setBackground(Color.gray);
        this.film = film;
        film.addObserver(this);
        this.addMouseMotionListener(this);
    }

    void paintRamka(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.camW = (int)((double)width * this.kSize);
        this.camH = (int)((double)height * this.kSize);
        this.camX = (dimension.width - this.camW) / 2 + this.xc;
        this.camY = (dimension.height - this.camH) / 2 + this.yc;
        graphics.setColor(Color.red);
        graphics.drawRect(this.camX, this.camY, this.camW, this.camH);
        int n = this.camH / 5;
        graphics.drawRoundRect(this.camX + n / 2, this.camY + n / 2, this.camW - n, this.camH - n, n, n);
        int n2 = this.camX + this.camW / 2;
        int n3 = this.camY + this.camH / 2;
        graphics.drawLine(n2 - 4, n3, n2 + 4, n3);
        graphics.drawLine(n2, n3 - 4, n2, n3 + 4);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.adjust = true;
        this.x1 = mouseEvent.getX();
        this.y1 = mouseEvent.getY();
        if (this.adjustCenter) {
            this.xc = this.x1 - this.x0;
            this.yc = this.y1 - this.y0;
        } else {
            int n = this.xs + width / 2;
            int n2 = this.ys + height / 2;
            double d = Math.sqrt((this.x0 - n) * (this.x0 - n) + (this.y0 - n2) * (this.y0 - n2));
            double d2 = Math.sqrt((this.x1 - n) * (this.x1 - n) + (this.y1 - n2) * (this.y1 - n2));
            this.kSize = d2 / d;
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.x0 = mouseEvent.getX();
        this.y0 = mouseEvent.getY();
        if (this.adjust) {
            int n = width;
            int n2 = height;
            Camera.screenWidth = n;
            Camera.screenX0 = (double)n / 2.0;
            Camera.screenY0 = (double)n2 / 2.0;
            this.film.selectedCamera.set();
            this.film.selectedCamera.selectZoom(this.xc, this.yc, 1.0 / this.kSize);
            this.xc = 0;
            this.yc = 0;
            this.kSize = 1.0;
            this.repaint();
            this.adjust = false;
            return;
        }
        int n = this.x0 - this.xs;
        int n3 = this.y0 - this.ys;
        this.adjustCenter = n > 0 && n < width && n3 > 0 && n3 < height;
    }

    public void update(Observable observable, Object object) {
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.xs = (dimension.width - width) / 2;
        this.ys = (dimension.height - height) / 2;
        Camera.mode = 1;
        if (!this.adjust) {
            this.offscreen = this.makeDoubleBuffer(width, height);
            this.makeImage(this.offscreen, this.film.nFrame);
        }
        graphics.setColor(Color.gray);
        graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.drawImage(this.offscreen.image, this.xs, this.ys, this);
        if (this.film.selectedCamera != null) {
            this.paintRamka(graphics);
        }
    }

    synchronized void makeImage(OffScreen offScreen, int n) {
        int n2 = width;
        int n3 = height;
        Camera.screenWidth = n2;
        Camera.screenX0 = (double)n2 / 2.0;
        Camera.screenY0 = (double)n3 / 2.0;
        Camera camera = this.film.selectedCamera;
        if (camera == null) {
            camera = this.film.tmpCamera(n, 0.0);
        }
        camera.set();
        offScreen.GC.setColor(Color.white);
        offScreen.GC.fillRect(0, 0, offScreen.size.width, offScreen.size.height);
        this.film.paint(offScreen.GC, n, 0.0);
    }

    OffScreen makeDoubleBuffer(int n, int n2) {
        return new OffScreen(new Dimension(n, n2), this.createImage(n, n2));
    }
}

