/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class fileService
extends Dialog
implements Runnable,
ActionListener {
    static final byte SAME = 0;
    static final byte DIFF = 1;
    static final int READY = 0;
    static final int WORK = 1;
    static final int ERR = 2;
    Thread workThread;
    GUI frame;
    DataOutputStream pout;
    BufferedInputStream instream;
    ObjectInputStream pin;
    DataInputStream pinData;
    Vector hdrVec;
    Vector kadrVec;
    Film film;
    Film updatedFilm;
    double rd;
    Button cancelButton;
    boolean loadComplete = false;
    String fileName;
    int hdrSize;
    int kadrSize;
    boolean frameMode = false;
    statusBar whatDo;
    boolean useFloat = false;
    boolean forWeb = false;
    int[] shapeLen;
    int status;
    boolean merge;
    boolean underLay;

    public int getStatus() {
        return this.status;
    }

    fileService(GUI gUI) {
        super((Frame)gUI, "File...");
        this.frameMode = true;
        this.frame = gUI;
        this.setLayout(new BorderLayout());
        this.whatDo = new statusBar();
        this.add("North", new Label("Load project", 1));
        this.add("Center", this.whatDo);
        Panel panel = new Panel();
        this.cancelButton = new Button("Cancel");
        panel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.add("South", panel);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        ((Component)this).setLocation((dimension.width - 380) / 2, (dimension.height - 110) / 2 - 20);
        ((Component)this).setSize(380, 110);
    }

    fileService() {
        super(new Frame(), "");
        this.frameMode = false;
        this.frame = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Cancel")) {
            this.stop();
        }
    }

    public void save(DataOutputStream dataOutputStream, Film film, boolean bl) {
        this.pout = dataOutputStream;
        this.film = film;
        this.hdrVec = film.headerVec;
        this.kadrVec = film.kadrVec;
        this.forWeb = bl;
        this.save1();
    }

    void saveBakFile() {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(String.valueOf(this.fileName) + ".bak");
            this.pout = new DataOutputStream(fileOutputStream);
            this.whatDo.set("Save *.bak file", 0.0);
            this.save1();
            this.saveCameras();
            this.pout.flush();
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            new errMessage(this.frame, "ERROR01 open ostream|" + fileOutputStream);
            return;
        }
    }

    public boolean load(String string, Film film, boolean bl, boolean bl2) {
        ((Component)this).setVisible(true);
        this.fileName = string;
        this.merge = bl;
        this.underLay = bl2;
        this.updatedFilm = film;
        this.status = 1;
        try {
            try {
                this.instream = new BufferedInputStream(new FileInputStream(string), 2048);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.frame != null) {
                    new errMessage(this.frame, "\"" + string + "\"" + "|ERROR02 File NOT Found");
                } else {
                    System.out.println("ERROR03: File Not Found " + string);
                }
                return false;
            }
            this.instream.mark(32000);
            this.pinData = new DataInputStream(this.instream);
            this.loadComplete = false;
            this.film = new Film();
            this.film.headerVec = new Vector();
            this.film.kadrVec = new Vector();
            this.hdrVec = this.film.headerVec;
            this.kadrVec = this.film.kadrVec;
            if (this.frame != null) {
                this.whatDo.set("Load header", 1.0);
            }
            boolean bl3 = true;
            if (!this.loadHeaderData()) {
                bl3 = false;
                this.instream.reset();
                this.pin = new ObjectInputStream(this.instream);
                if (!this.loadHeader()) {
                    ((FilterInputStream)this.instream).close();
                    return false;
                }
            }
            Vector vector = this.film.headerVec;
            int n = 0;
            while (n < vector.size()) {
                shapeHeader shapeHeader2 = (shapeHeader)vector.elementAt(n);
                shapeHeader2.updateBitmap();
                ++n;
            }
            if (bl3) {
                this.start();
            } else {
                this.run1();
            }
        }
        catch (IOException iOException) {
            if (this.frame != null) {
                new errMessage(this.frame, "ERROR04 open instream|" + this.instream);
            } else {
                System.out.println("ERROR05\topen file " + string);
            }
            return false;
        }
        return true;
    }

    public void init() {
    }

    public void stop() {
        this.film.selectedCamera = null;
        if (this.film.stopKadrN == 0) {
            this.film.stopKadrN = this.film.duration();
        }
        if (this.frameMode) {
            this.saveBakFile();
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {}
        ((Component)this).setVisible(false);
        if (this.loadComplete) {
            if (!this.merge) {
                this.updatedFilm.update(this.film);
            } else {
                this.updatedFilm.merge(this.film, this.underLay);
            }
            this.status = 0;
        } else {
            this.status = 64;
        }
        try {
            ((FilterInputStream)this.instream).close();
        }
        catch (IOException iOException) {
            new errMessage(this.frame, "ERROR06 closing instream|" + this.instream);
        }
        if (this.workThread != null) {
            this.workThread.stop();
            this.workThread = null;
        }
    }

    public void start() {
        this.loadCamerasData();
        this.workThread = new Thread(this);
        this.workThread.start();
    }

    public void run1() {
        if (this.useFloat) {
            this.loadCameras();
        }
        while (this.kadrVec.size() < this.kadrSize) {
            if (this.frameMode) {
                this.kadrVec.size();
                this.whatDo.set((double)this.kadrVec.size() / (double)this.kadrSize);
            }
            if (this.loadFrame()) continue;
            System.out.println("ERROR07 loading FILE");
            this.stop();
        }
        if (!this.useFloat) {
            this.loadCameras();
        }
        this.film.selectedCamera = null;
        if (this.film.stopKadrN == 0) {
            this.film.stopKadrN = this.film.duration();
        }
        this.loadComplete = true;
        this.stop();
    }

    boolean save1() {
        int n;
        Serializable serializable;
        int n2;
        short s;
        try {
            long l = 4857212832643625009L;
            if (this.forWeb) {
                l += 2L;
            }
            this.pout.writeLong(l);
            this.pout.writeInt(this.hdrVec.size());
            this.pout.writeInt(this.kadrVec.size());
            this.pout.writeBoolean(this.film.loop);
            this.pout.writeInt(this.film.startKadrN);
            this.pout.writeInt(this.film.stopKadrN);
            this.pout.writeShort(this.film.fps);
            s = 0;
            if (this.film.renderFields) {
                s = (short)(s | 1);
            }
            if (this.film.lowerFieldFirst) {
                s = (short)(s | 2);
            }
            this.pout.writeShort(s);
            this.pout.writeShort(this.film.renderWidth);
            this.pout.writeShort(this.film.renderHeight);
            this.pout.writeShort(this.film.selectedKadrN);
            this.pout.writeShort(this.film.activeCameraN);
        }
        catch (IOException iOException) {
            new errMessage(this.frame, "ERROR08 writing object");
            return false;
        }
        int n3 = 0;
        while (n3 < this.hdrVec.size()) {
            shapeHeader shapeHeader2 = (shapeHeader)this.hdrVec.elementAt(n3);
            n2 = -1;
            s = 0;
            while (s < this.hdrVec.size()) {
                if (shapeHeader2.mammy == this.hdrVec.elementAt(s)) {
                    n2 = s;
                    break;
                }
                s = (short)(s + 1);
            }
            try {
                this.pout.writeInt(shapeHeader2.type);
                this.pout.writeInt(shapeHeader2.fillColor.getRGB());
                this.pout.writeInt(shapeHeader2.borderColor.getRGB());
                this.pout.writeInt(shapeHeader2.bType);
                this.pout.writeInt(shapeHeader2.bWidth);
                this.pout.writeInt(shapeHeader2.order);
                this.pout.writeBoolean(shapeHeader2.filled);
                this.pout.writeBoolean(shapeHeader2.bordered);
                this.pout.writeInt(n2);
                this.pout.writeInt(shapeHeader2.name.length());
                this.pout.writeChars(shapeHeader2.name);
            }
            catch (IOException iOException) {
                System.out.println("ERROR09 write object");
                new errMessage(this.frame, "ERROR10 writing object");
                return false;
            }
            if (this.forWeb) {
                try {
                    Kadr kadr = (Kadr)this.kadrVec.elementAt(0);
                    serializable = (ChShape)kadr.shapeVector.elementAt(n3);
                    n = ((ChShape)serializable).pointVector.size();
                    this.pout.writeInt(n);
                }
                catch (IOException iOException) {
                    System.out.println("ERROR09A write object");
                    new errMessage(this.frame, "ERROR10A writing object");
                    return false;
                }
            }
            ++n3;
        }
        this.saveCameras();
        n2 = 0;
        while (n2 < this.kadrVec.size()) {
            Kadr kadr = (Kadr)this.kadrVec.elementAt(n2);
            int n4 = n2 > 0 ? n2 - 1 : 0;
            serializable = (Kadr)this.kadrVec.elementAt(n4);
            try {
                this.pout.writeFloat((float)((double)kadr.frameNum));
            }
            catch (IOException iOException) {
                System.out.println("ERROR11 write object");
                new errMessage(this.frame, "ERROR12 writing object");
                return false;
            }
            n = 0;
            while (n < kadr.shapeVector.size()) {
                int n5;
                shapeHeader shapeHeader3 = (shapeHeader)this.film.headerVec.elementAt(n);
                boolean bl = shapeHeader3.getLinear();
                ChShape chShape = (ChShape)kadr.shapeVector.elementAt(n);
                ChShape chShape2 = (ChShape)serializable.shapeVector.elementAt(n);
                try {
                    this.pout.writeBoolean(chShape.hidden);
                    if (!this.forWeb) {
                        this.pout.writeInt(chShape.pointVector.size());
                    }
                }
                catch (IOException iOException) {
                    new errMessage(this.frame, "ERROR14 writing shape");
                    return false;
                }
                if (this.forWeb) {
                    double d;
                    double d2;
                    n5 = 1;
                    shapePoint shapePoint2 = (shapePoint)chShape.pointVector.elementAt(0);
                    double d3 = d2 = shapePoint2.x[1];
                    double d4 = d = shapePoint2.y[1];
                    int n6 = 0;
                    while (n6 < chShape.pointVector.size()) {
                        shapePoint2 = (shapePoint)chShape.pointVector.elementAt(n6);
                        shapePoint shapePoint3 = (shapePoint)chShape2.pointVector.elementAt(n6);
                        int n7 = 0;
                        while (n7 < 3) {
                            if (!bl || n7 != 0 && n7 != 2) {
                                d3 = Math.min(d3, shapePoint2.x[n7]);
                                d2 = Math.max(d2, shapePoint2.x[n7]);
                                d4 = Math.min(d4, shapePoint2.y[n7]);
                                d = Math.max(d, shapePoint2.y[n7]);
                                if (shapePoint2.x[n7] != shapePoint3.x[n7] || shapePoint2.y[n7] != shapePoint3.y[n7]) {
                                    n5 = 0;
                                }
                            }
                            ++n7;
                        }
                        ++n6;
                    }
                    if (n2 > 0 && n5 != 0) {
                        try {
                            this.pout.writeByte(0);
                        }
                        catch (IOException iOException) {
                            new errMessage(this.frame, "ERROR15A writing| shape point");
                            return false;
                        }
                    }
                    double d5 = (d2 - d3) / 2.0;
                    double d6 = (d - d4) / 2.0;
                    d3 = (d3 + d2) / 2.0;
                    d4 = (d4 + d) / 2.0;
                    try {
                        this.pout.writeByte(1);
                        this.pout.writeFloat((float)d3);
                        this.pout.writeFloat((float)d4);
                        this.pout.writeFloat((float)d5);
                        this.pout.writeFloat((float)d6);
                    }
                    catch (IOException iOException) {
                        new errMessage(this.frame, "ERROR15A writing| shape point");
                        return false;
                    }
                    int n8 = 0;
                    while (n8 < chShape.pointVector.size()) {
                        shapePoint2 = (shapePoint)chShape.pointVector.elementAt(n8);
                        int n9 = 0;
                        while (n9 < 3) {
                            if (!bl || n9 != 0 && n9 != 2) {
                                try {
                                    byte by = (byte)(127.0 * (shapePoint2.x[n9] - d3) / d5);
                                    byte by2 = (byte)(127.0 * (shapePoint2.y[n9] - d4) / d6);
                                    this.pout.writeByte(by);
                                    this.pout.writeByte(by2);
                                }
                                catch (IOException iOException) {
                                    new errMessage(this.frame, "ERROR15A writing| shape point");
                                    return false;
                                }
                            }
                            ++n9;
                        }
                        ++n8;
                    }
                } else {
                    n5 = 0;
                    while (n5 < chShape.pointVector.size()) {
                        shapePoint shapePoint4 = (shapePoint)chShape.pointVector.elementAt(n5);
                        shapePoint shapePoint5 = (shapePoint)chShape2.pointVector.elementAt(n5);
                        try {
                            if (n2 > 0 && shapePoint4.equalTo(shapePoint5)) {
                                this.pout.writeByte(0);
                            } else {
                                this.pout.writeByte(1);
                                this.pout.writeFloat((float)shapePoint4.x[0]);
                                this.pout.writeFloat((float)shapePoint4.y[0]);
                                this.pout.writeFloat((float)shapePoint4.x[1]);
                                this.pout.writeFloat((float)shapePoint4.y[1]);
                                this.pout.writeFloat((float)shapePoint4.x[2]);
                                this.pout.writeFloat((float)shapePoint4.y[2]);
                            }
                        }
                        catch (IOException iOException) {
                            new errMessage(this.frame, "ERROR15 writing| shape point");
                            return false;
                        }
                        ++n5;
                    }
                }
                ++n;
            }
            ++n2;
        }
        return true;
    }

    boolean loadHeader() {
        try {
            long l = this.pin.readLong();
            if ((l & 0xFFFFFFFF00000000L) != 4857212831835095040L) {
                new errMessage(this.frame, "ERROR16| This is not ChIV file.");
                return false;
            }
            this.useFloat = (l & 1L) == 1L;
            this.hdrSize = this.pin.readInt();
            this.kadrSize = this.pin.readInt();
            this.film.loop = this.pin.readBoolean();
            this.film.startKadrN = this.pin.readInt();
            this.film.stopKadrN = this.pin.readInt();
            this.pin.readInt();
            this.film.selectedKadrN = this.pin.readInt();
            this.film.activeCameraN = this.pin.readInt();
        }
        catch (IOException iOException) {
            new errMessage(this.frame, "ERROR17 reading file header");
            return false;
        }
        Vector vector = this.hdrVec;
        synchronized (vector) {
            int n;
            shapeHeader shapeHeader2;
            int[] nArray = new int[this.hdrSize];
            int n2 = 0;
            while (n2 < this.hdrSize) {
                shapeHeader2 = new shapeHeader();
                try {
                    shapeHeader2.type = this.pin.readInt();
                    int n3 = this.pin.readInt();
                    int n4 = this.pin.readInt();
                    int n5 = this.pin.readInt();
                    shapeHeader2.fillColor = new Color(n3, n4, n5);
                    n3 = this.pin.readInt();
                    n4 = this.pin.readInt();
                    n5 = this.pin.readInt();
                    shapeHeader2.borderColor = new Color(n3, n4, n5);
                    shapeHeader2.bType = this.pin.readInt();
                    shapeHeader2.bWidth = this.pin.readInt();
                    shapeHeader2.order = this.pin.readInt();
                    shapeHeader2.filled = this.pin.readBoolean();
                    shapeHeader2.bordered = this.pin.readBoolean();
                    nArray[n2] = this.pin.readInt();
                    n = this.pin.readInt();
                    char[] cArray = new char[n];
                    int n6 = 0;
                    while (n6 < n) {
                        cArray[n6] = this.pin.readChar();
                        ++n6;
                    }
                    shapeHeader2.name = new String(cArray);
                }
                catch (IOException iOException) {
                    new errMessage(this.frame, "ERROR18 reading header");
                    boolean bl = false;
                    Object var4_13 = null;
                    return bl;
                }
                this.hdrVec.addElement(shapeHeader2);
                ++n2;
            }
            n = 0;
            while (n < this.hdrSize) {
                if (nArray[n] != -1) {
                    shapeHeader2 = (shapeHeader)this.hdrVec.elementAt(n);
                    shapeHeader2.mammy = (shapeHeader)this.hdrVec.elementAt(nArray[n]);
                }
                ++n;
            }
        }
        return true;
    }

    boolean loadFrame() {
        Kadr kadr = new Kadr(5);
        try {
            kadr.frameNum = this.useFloat ? (int)this.pin.readFloat() : (int)this.pin.readDouble();
        }
        catch (IOException iOException) {
            new errMessage(this.frame, "ERROR19 reading object");
            return false;
        }
        int n = 0;
        while (n < this.hdrSize) {
            int n2;
            ChShape chShape = new ChShape();
            try {
                chShape.hidden = this.pin.readBoolean();
                n2 = this.pin.readInt();
            }
            catch (IOException iOException) {
                new errMessage(this.frame, "ERROR20 reading object");
                return false;
            }
            int n3 = 0;
            while (n3 < n2) {
                shapePoint shapePoint2;
                try {
                    byte by = this.pin.readByte();
                    if (by == 1) {
                        shapePoint2 = new shapePoint(0, 0, 0, 0, 0, 0);
                        if (this.useFloat) {
                            shapePoint2.x[0] = this.pin.readFloat();
                            shapePoint2.y[0] = this.pin.readFloat();
                            shapePoint2.x[1] = this.pin.readFloat();
                            shapePoint2.y[1] = this.pin.readFloat();
                            shapePoint2.x[2] = this.pin.readFloat();
                            shapePoint2.y[2] = this.pin.readFloat();
                        } else {
                            shapePoint2.x[0] = this.pin.readDouble();
                            shapePoint2.y[0] = this.pin.readDouble();
                            shapePoint2.x[1] = this.pin.readDouble();
                            shapePoint2.y[1] = this.pin.readDouble();
                            shapePoint2.x[2] = this.pin.readDouble();
                            shapePoint2.y[2] = this.pin.readDouble();
                        }
                    } else {
                        Kadr kadr2 = (Kadr)this.kadrVec.elementAt(this.kadrVec.size() - 1);
                        ChShape chShape2 = (ChShape)kadr2.shapeVector.elementAt(n);
                        shapePoint2 = new shapePoint((shapePoint)chShape2.pointVector.elementAt(n3));
                    }
                }
                catch (IOException iOException) {
                    new errMessage(this.frame, "ERROR21 reading object");
                    return false;
                }
                chShape.pointVector.addElement(shapePoint2);
                ++n3;
            }
            kadr.shapeVector.addElement(chShape);
            ++n;
        }
        this.kadrVec.addElement(kadr);
        return true;
    }

    boolean loadCameras() {
        int n = 0;
        try {
            n = this.pin.readInt();
        }
        catch (IOException iOException) {
            new errMessage(this.frame, "ERROR22 reading camNum");
            return false;
        }
        this.film.camVec = new Vector();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            camTime camTime2 = new camTime();
            camTime2.camVec = new Vector();
            try {
                n3 = this.pin.readInt();
            }
            catch (IOException iOException) {
                new errMessage(this.frame, "ERROR23 reading camKeyN");
                return false;
            }
            int n4 = 0;
            while (n4 < n3) {
                Camera camera = new Camera();
                try {
                    if (this.useFloat) {
                        camera.cameraX0 = this.pin.readFloat();
                        camera.cameraY0 = this.pin.readFloat();
                        camera.cameraZoom = this.pin.readFloat();
                        camera.timePosition = this.pin.readFloat();
                    } else {
                        camera.cameraX0 = this.pin.readDouble();
                        camera.cameraY0 = this.pin.readDouble();
                        camera.cameraZoom = this.pin.readDouble();
                        camera.timePosition = this.pin.readDouble();
                    }
                }
                catch (IOException iOException) {
                    new errMessage(this.frame, "ERROR24 reading Camera Parameters");
                    return false;
                }
                camTime2.camVec.addElement(camera);
                ++n4;
            }
            this.film.camVec.addElement(camTime2);
            ++n2;
        }
        return true;
    }

    boolean saveCameras() {
        int n = this.film.camVec.size();
        try {
            this.pout.writeInt(n);
        }
        catch (IOException iOException) {
            new errMessage(this.frame, "ERROR25 writing Cameras");
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            camTime camTime2 = (camTime)this.film.camVec.elementAt(n2);
            int n3 = camTime2.camVec.size();
            try {
                this.pout.writeInt(n3);
            }
            catch (IOException iOException) {
                new errMessage(this.frame, "ERROR26 writing Cameras");
                return false;
            }
            int n4 = 0;
            while (n4 < n3) {
                Camera camera = (Camera)camTime2.camVec.elementAt(n4);
                try {
                    this.pout.writeFloat((float)camera.cameraX0);
                    this.pout.writeFloat((float)camera.cameraY0);
                    this.pout.writeFloat((float)camera.cameraZoom);
                    this.pout.writeFloat((float)camera.timePosition);
                }
                catch (IOException iOException) {
                    new errMessage(this.frame, "ERROR27 writing Cameras");
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Film film = this.updatedFilm;
        synchronized (film) {
            while (true) {
                if (this.kadrVec.size() >= this.kadrSize) {
                    this.loadComplete = true;
                    this.stop();
                    return;
                }
                if (!this.loadFrameData()) {
                    System.out.println("ERROR28 loading FILE");
                    this.stop();
                }
                if (!this.frameMode) continue;
                this.kadrVec.size();
                try {
                    Thread.sleep(10L);
                    this.whatDo.set((double)this.kadrVec.size() / (double)this.kadrSize);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    boolean loadCamerasData() {
        int n = 0;
        try {
            n = this.pinData.readInt();
        }
        catch (IOException iOException) {
            new errMessage(this.frame, "ERROR29 reading camNum");
            return false;
        }
        this.film.camVec = new Vector();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            camTime camTime2 = new camTime();
            camTime2.camVec = new Vector();
            try {
                n3 = this.pinData.readInt();
            }
            catch (IOException iOException) {
                new errMessage(this.frame, "ERROR30 reading camKeyN");
                return false;
            }
            int n4 = 0;
            while (n4 < n3) {
                Camera camera = new Camera();
                try {
                    camera.cameraX0 = this.pinData.readFloat();
                    camera.cameraY0 = this.pinData.readFloat();
                    camera.cameraZoom = this.pinData.readFloat();
                    camera.timePosition = this.pinData.readFloat();
                }
                catch (IOException iOException) {
                    new errMessage(this.frame, "ERROR31 reading Camera Parameters");
                    return false;
                }
                camTime2.camVec.addElement(camera);
                ++n4;
            }
            this.film.camVec.addElement(camTime2);
            ++n2;
        }
        return true;
    }

    boolean loadFrameData() {
        Kadr kadr = new Kadr(5);
        try {
            kadr.frameNum = (int)this.pinData.readFloat();
        }
        catch (IOException iOException) {
            new errMessage(this.frame, "ERROR32 reading object");
            return false;
        }
        int n = 0;
        while (n < this.hdrSize) {
            int n2;
            shapeHeader shapeHeader2 = (shapeHeader)this.film.headerVec.elementAt(n);
            boolean bl = shapeHeader2.getLinear();
            ChShape chShape = new ChShape();
            int n3 = 1;
            if (this.forWeb) {
                n3 = this.shapeLen[n];
            }
            try {
                chShape.hidden = this.pinData.readBoolean();
                if (!this.forWeb) {
                    n3 = this.pinData.readInt();
                }
            }
            catch (IOException iOException) {
                new errMessage(this.frame, "ERROR33 reading object");
                return false;
            }
            if (this.forWeb) {
                try {
                    n2 = this.pinData.readByte();
                    if (n2 == 1) {
                        float f = this.pinData.readFloat();
                        float f2 = this.pinData.readFloat();
                        float f3 = this.pinData.readFloat();
                        float f4 = this.pinData.readFloat();
                        int n4 = 0;
                        while (n4 < n3) {
                            shapePoint shapePoint2 = new shapePoint(0, 0, 0, 0, 0, 0);
                            int n5 = 0;
                            while (n5 < 3) {
                                if (!bl || n5 != 0 && n5 != 2) {
                                    byte by = this.pinData.readByte();
                                    byte by2 = this.pinData.readByte();
                                    shapePoint2.x[n5] = (double)f + (double)((float)by * f3) / 127.0;
                                    shapePoint2.y[n5] = (double)f2 + (double)((float)by2 * f4) / 127.0;
                                }
                                ++n5;
                            }
                            if (bl) {
                                shapePoint2.x[0] = shapePoint2.x[1];
                                shapePoint2.y[0] = shapePoint2.y[1];
                                shapePoint2.x[2] = shapePoint2.x[1];
                                shapePoint2.y[2] = shapePoint2.y[1];
                            }
                            chShape.pointVector.addElement(shapePoint2);
                            ++n4;
                        }
                    }
                    Kadr kadr2 = (Kadr)this.kadrVec.elementAt(this.kadrVec.size() - 1);
                    ChShape chShape2 = (ChShape)kadr2.shapeVector.elementAt(n);
                    int n6 = 0;
                    while (n6 < n3) {
                        shapePoint shapePoint3 = new shapePoint((shapePoint)chShape2.pointVector.elementAt(n6));
                        chShape.pointVector.addElement(shapePoint3);
                        ++n6;
                    }
                }
                catch (IOException iOException) {
                    new errMessage(this.frame, "ERROR15A writing| shape point");
                    return false;
                }
            } else {
                n2 = 0;
                while (n2 < n3) {
                    shapePoint shapePoint4;
                    try {
                        byte by = this.pinData.readByte();
                        if (by == 1) {
                            shapePoint4 = new shapePoint(0, 0, 0, 0, 0, 0);
                            shapePoint4.x[0] = this.pinData.readFloat();
                            shapePoint4.y[0] = this.pinData.readFloat();
                            shapePoint4.x[1] = this.pinData.readFloat();
                            shapePoint4.y[1] = this.pinData.readFloat();
                            shapePoint4.x[2] = this.pinData.readFloat();
                            shapePoint4.y[2] = this.pinData.readFloat();
                        } else {
                            Kadr kadr3 = (Kadr)this.kadrVec.elementAt(this.kadrVec.size() - 1);
                            ChShape chShape3 = (ChShape)kadr3.shapeVector.elementAt(n);
                            shapePoint4 = new shapePoint((shapePoint)chShape3.pointVector.elementAt(n2));
                        }
                    }
                    catch (IOException iOException) {
                        new errMessage(this.frame, "ERROR34 reading data");
                        return false;
                    }
                    chShape.pointVector.addElement(shapePoint4);
                    ++n2;
                }
            }
            kadr.shapeVector.addElement(chShape);
            ++n;
        }
        this.kadrVec.addElement(kadr);
        return true;
    }

    boolean loadHeaderData() {
        try {
            int n;
            long l = this.pinData.readLong();
            if ((l & 0xFFFFFFFF00000000L) != 4857212831835095040L) {
                return false;
            }
            this.forWeb = (l & 2L) == 2L;
            this.hdrSize = this.pinData.readInt();
            this.kadrSize = this.pinData.readInt();
            this.film.loop = this.pinData.readBoolean();
            this.film.startKadrN = this.pinData.readInt();
            this.film.stopKadrN = this.pinData.readInt();
            this.film.fps = this.pinData.readUnsignedShort();
            if (this.film.fps == 0) {
                this.film.fps = 2500;
            }
            this.film.renderFields = ((n = this.pinData.readUnsignedShort()) & 1) != 0;
            this.film.lowerFieldFirst = (n & 2) != 0;
            this.film.renderWidth = this.pinData.readUnsignedShort();
            this.film.renderHeight = this.pinData.readUnsignedShort();
            System.out.println("Read film.renderFields=" + this.film.renderFields + "  lowerFieldFirst=" + this.film.lowerFieldFirst);
            this.film.selectedKadrN = this.pinData.readUnsignedShort();
            this.film.activeCameraN = this.pinData.readUnsignedShort();
        }
        catch (IOException iOException) {
            new errMessage(this.frame, "ERROR36 reading file header");
            return false;
        }
        Vector vector = this.hdrVec;
        synchronized (vector) {
            int n;
            shapeHeader shapeHeader2;
            int[] nArray = new int[this.hdrSize];
            this.shapeLen = new int[this.hdrSize];
            int n2 = 0;
            while (n2 < this.hdrSize) {
                shapeHeader2 = new shapeHeader();
                try {
                    shapeHeader2.type = this.pinData.readInt();
                    int n3 = this.pinData.readInt();
                    shapeHeader2.fillColor = new Color(n3);
                    n3 = this.pinData.readInt();
                    shapeHeader2.borderColor = new Color(n3);
                    shapeHeader2.bType = this.pinData.readInt();
                    shapeHeader2.bWidth = this.pinData.readInt();
                    shapeHeader2.order = this.pinData.readInt();
                    shapeHeader2.filled = this.pinData.readBoolean();
                    shapeHeader2.bordered = this.pinData.readBoolean();
                    nArray[n2] = this.pinData.readInt();
                    n = this.pinData.readInt();
                    char[] cArray = new char[n];
                    int n4 = 0;
                    while (n4 < n) {
                        cArray[n4] = this.pinData.readChar();
                        ++n4;
                    }
                    shapeHeader2.name = new String(cArray);
                }
                catch (IOException iOException) {
                    new errMessage(this.frame, "ERROR37 reading header");
                    boolean bl = false;
                    Object var4_5 = null;
                    return bl;
                }
                if (this.forWeb) {
                    try {
                        this.shapeLen[n2] = n = this.pinData.readInt();
                    }
                    catch (IOException iOException) {
                        new errMessage(this.frame, "ERROR37 reading header");
                        boolean bl = false;
                        Object var4_6 = null;
                        return bl;
                    }
                }
                this.hdrVec.addElement(shapeHeader2);
                ++n2;
            }
            n = 0;
            while (n < this.hdrSize) {
                if (nArray[n] != -1) {
                    shapeHeader2 = (shapeHeader)this.hdrVec.elementAt(n);
                    shapeHeader2.mammy = (shapeHeader)this.hdrVec.elementAt(nArray[n]);
                }
                ++n;
            }
        }
        return true;
    }
}

