/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;

class camCanvas
extends Component
implements MouseListener,
MouseMotionListener {
    static final int NOTHING = 0;
    static final int FRAME = 1;
    static final int CAMERA = 2;
    static final int START_MARK = 3;
    static final int STOP_MARK = 4;
    int selection = 0;
    Image offscreen;
    cameraDialog cameradialog;
    Film film;
    double time;
    int nTime;
    int ppf = 5;
    int dtime0 = 60;
    int width = 2200;
    int height = 80;
    int dh1;
    int dh2;
    int dh3;
    int kmax;
    int[] kPos;
    double total;

    camCanvas(cameraDialog cameraDialog2, Film film) {
        this.film = film;
        this.selectCameraKey(0.0);
        this.cameradialog = cameraDialog2;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(cameraDialog2.gui);
        this.setBackground(Color.white);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.offscreen == null || this.cameradialog.chsound.newSound) {
            if (this.offscreen == null) {
                this.offscreen = this.createImage(this.width, this.height);
            }
            Graphics graphics2 = this.offscreen.getGraphics();
            this.dh1 = this.height / 4;
            this.dh2 = this.height / 2;
            this.dh3 = this.dh1 + this.dh2;
            graphics2.setColor(Color.white);
            graphics2.fillRect(0, 0, this.width - 1, this.height);
            if (this.cameradialog.chsound.newSound) {
                this.cameradialog.chsound.paintSound(graphics2, this.dh2);
                this.cameradialog.chsound.newSound = false;
                graphics2.setColor(Color.black);
                graphics2.drawString(this.cameradialog.chsound.soundFileName, 4, this.height - 6);
            }
            graphics2.setColor(Color.black);
            graphics2.drawLine(0, this.dh1, this.width - 1, this.dh1);
            graphics2.drawString("Frame #", 4, this.dh1 - 6);
            graphics2.drawLine(0, this.dh2, this.width - 1, this.dh2);
            graphics2.drawString("Key", 4, this.dh2 - 6);
            graphics2.drawLine(0, this.dh3, this.width - 1, this.dh3);
            graphics2.drawString("Camera", 4, this.dh3 - 6);
            int n = this.dtime0;
            while (n < this.width - 1) {
                graphics2.drawLine(n, this.dh1 - 3, n, this.dh1);
                n += this.ppf;
            }
            int n2 = this.dtime0;
            while (n2 < this.width - 1) {
                graphics2.drawLine(n2, this.dh1 - 6, n2, this.dh1);
                n2 += 5 * this.ppf;
            }
            int n3 = 1;
            int n4 = this.dtime0;
            while (n4 < this.width - 1) {
                graphics2.drawLine(n4, 0, n4, this.height);
                graphics2.drawString(Integer.toString(n3), n4 + 2, this.dh1 - 6);
                n3 += 25;
                n4 += 25 * this.ppf;
            }
        }
        this.kmax = this.film.kadrVec.size();
        this.kPos = new int[this.kmax + 1];
        this.kPos[0] = 0;
        int n = 0;
        while (n < this.kmax) {
            Kadr kadr = (Kadr)this.film.kadrVec.elementAt(n);
            this.kPos[n + 1] = this.kPos[n] + kadr.frameNum;
            ++n;
        }
        this.total = this.kPos[this.kmax];
        graphics.drawImage(this.offscreen, 0, 0, null);
        this.drawTimeMarker(graphics, this.time);
        if (this.film.activeCameraN >= 0) {
            this.showCameraKeys(graphics);
        }
        this.showFrameKeys(graphics);
    }

    double xToTime(int n) {
        double d = (double)((n - this.dtime0) / this.ppf) / this.total;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    int xToFrame(int n) {
        int n2 = (n - this.dtime0) / this.ppf;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.film.duration()) {
            n2 = this.film.duration();
        }
        return n2;
    }

    int timeToX(double d) {
        return this.dtime0 + (int)(this.total * d) * this.ppf;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        double d;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.time = d = this.xToTime(n);
        if (n2 >= this.dh3) {
            int n3 = this.xToFrame(n);
            this.selection = n3 - this.film.startKadrN > this.film.stopKadrN - n3 ? 4 : 3;
            this.film.selectedCamera = null;
        }
        if (n2 < this.dh1) {
            this.selection = 0;
            this.time = d;
            this.film.selectedCamera = null;
        }
        if (n2 >= this.dh1 && n2 < this.dh2) {
            this.selection = 1;
            this.film.setSelectedKeyFrame(d);
            this.time = (double)this.kPos[this.film.selectedKadrN] / (double)this.film.duration();
            this.film.selectedCamera = null;
        }
        if (n2 >= this.dh2 && n2 < this.dh3) {
            this.selection = 2;
            this.selectCameraKey(d);
            this.time = this.film.selectedCamera.timePosition;
        }
        if (this.selection != 0) {
            Cursor cursor = new Cursor(12);
            ((Component)this.cameradialog).setCursor(cursor);
        }
        this.film.nFrame = (int)(this.total * d);
        this.film.tell();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        ((Component)this.cameradialog).setCursor(new Cursor(0));
        this.film.tell();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl;
        int n = mouseEvent.getX();
        mouseEvent.getY();
        this.time = this.xToTime(n);
        int n2 = this.xToFrame(n);
        int n3 = (int)(this.total * this.time);
        boolean bl2 = bl = this.film.nFrame != n3;
        if (bl) {
            this.film.nFrame = n3;
        }
        if (this.selection == 2) {
            this.film.selectedCamera.timePosition = this.time;
        }
        if (this.selection == 3) {
            this.film.startKadrN = n2;
            if (this.film.startKadrN >= this.film.stopKadrN) {
                this.film.startKadrN = this.film.stopKadrN - 1;
            }
        }
        if (this.selection == 4) {
            this.film.stopKadrN = n2;
            if (this.film.startKadrN >= this.film.stopKadrN) {
                this.film.stopKadrN = this.film.startKadrN + 1;
            }
        }
        if (this.selection == 1 && this.film.selectedKadrN > 0) {
            Kadr kadr;
            int n4;
            int n5 = this.dtime0 + this.film.framePosition(this.film.selectedKadrN) * this.ppf;
            int n6 = (n - n5) / this.ppf;
            if (n6 == 0) {
                return;
            }
            if (n6 > 0) {
                if (mouseEvent.isControlDown()) {
                    n4 = this.film.selectedKadrN - 1;
                    int n7 = 0;
                    while (n7 <= n4) {
                        kadr = (Kadr)this.film.kadrVec.elementAt(n7);
                        ++kadr.frameNum;
                        ++n7;
                    }
                    this.film.stopKadrN += n4 + 1;
                    if (this.film.stopKadrN > this.film.duration()) {
                        this.film.stopKadrN = this.film.duration();
                    }
                } else if (!mouseEvent.isShiftDown()) {
                    if (this.film.selectedKadrN < this.film.kadrVec.size()) {
                        kadr = (Kadr)this.film.kadrVec.elementAt(this.film.selectedKadrN);
                        if (kadr.frameNum > 1) {
                            --kadr.frameNum;
                            Kadr kadr2 = (Kadr)this.film.kadrVec.elementAt(this.film.selectedKadrN - 1);
                            ++kadr2.frameNum;
                        }
                    }
                } else if (this.film.selectedKadrN > 0) {
                    n4 = this.film.selectedKadrN - 1;
                    kadr = (Kadr)this.film.kadrVec.elementAt(n4);
                    ++kadr.frameNum;
                }
            }
            if (n6 < 0) {
                if (mouseEvent.isControlDown()) {
                    n4 = 0;
                    while (n4 < this.film.selectedKadrN) {
                        kadr = (Kadr)this.film.kadrVec.elementAt(n4);
                        if (kadr.frameNum > 1) {
                            --kadr.frameNum;
                        }
                        ++n4;
                    }
                    this.film.stopKadrN -= this.film.selectedKadrN;
                    if (this.film.startKadrN >= this.film.stopKadrN) {
                        this.film.startKadrN = this.film.stopKadrN - 1;
                    }
                    if (this.film.startKadrN < 0) {
                        this.film.startKadrN = 0;
                        this.film.stopKadrN = 1;
                    }
                } else {
                    kadr = (Kadr)this.film.kadrVec.elementAt(this.film.selectedKadrN - 1);
                    if (kadr.frameNum > 1) {
                        --kadr.frameNum;
                        if (!mouseEvent.isShiftDown() && this.film.selectedKadrN < this.film.kadrVec.size()) {
                            kadr = (Kadr)this.film.kadrVec.elementAt(this.film.selectedKadrN);
                            ++kadr.frameNum;
                        }
                    }
                }
            }
            if (this.film.stopKadrN > this.film.duration()) {
                this.film.stopKadrN = this.film.duration();
            }
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void update(Observable observable, Object object) {
        this.repaint();
    }

    void showFrameKeys(Graphics graphics) {
        int n = 0;
        while (n <= this.kmax) {
            graphics.setColor(Color.darkGray);
            if (n == this.film.selectedKadrN) {
                if (this.selection == 1) {
                    graphics.setColor(Color.green.darker());
                } else {
                    graphics.setColor(Color.orange.darker());
                }
            }
            if (n < this.kmax) {
                graphics.fillRect(this.dtime0 + this.kPos[n] * this.ppf, this.dh2 - 12, this.ppf - 1, 11);
            } else {
                graphics.drawRect(this.dtime0 + this.kPos[n] * this.ppf, this.dh2 - 12, this.ppf - 1, 11);
            }
            ++n;
        }
        graphics.setXORMode(Color.white);
        graphics.setColor(Color.yellow.darker());
        int n2 = this.dtime0 + this.film.startKadrN * this.ppf + 1;
        int n3 = (this.film.stopKadrN - this.film.startKadrN) * this.ppf;
        graphics.fillRect(n2, this.dh3 + 1, n3, this.dh1 / 2);
        graphics.setPaintMode();
        if (this.selection == 3) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.black);
        }
        Polygon polygon = new Polygon();
        polygon.addPoint(n2, this.dh3);
        polygon.addPoint(n2, this.dh3 + this.dh1 / 2);
        polygon.addPoint(n2 + this.ppf, this.dh3 + this.dh1 / 4);
        graphics.fillPolygon(polygon);
        if (this.selection == 4) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.black);
        }
        polygon.xpoints[0] = polygon.xpoints[0] + n3;
        polygon.xpoints[1] = polygon.xpoints[1] + n3;
        polygon.xpoints[2] = polygon.xpoints[2] + (n3 - 2 * this.ppf);
        graphics.fillPolygon(polygon);
    }

    void showCameraKeys(Graphics graphics) {
        if (this.film.activeCameraN < 0) {
            return;
        }
        camTime camTime2 = (camTime)this.film.camVec.elementAt(this.film.activeCameraN);
        int n = 0;
        while (n < camTime2.camVec.size()) {
            Camera camera = (Camera)camTime2.camVec.elementAt(n);
            graphics.setColor(Color.blue.darker());
            if (camera == this.film.selectedCamera) {
                if (this.selection == 2) {
                    graphics.setColor(Color.green);
                } else {
                    graphics.setColor(Color.orange.darker());
                }
            }
            graphics.fillRect(this.timeToX(camera.timePosition), this.dh3 - 12, this.ppf - 1, 11);
            ++n;
        }
    }

    void drawTimeMarker(Graphics graphics, double d) {
        graphics.setColor(Color.red);
        int n = this.timeToX(d);
        Polygon polygon = new Polygon();
        polygon.addPoint(n, 9);
        polygon.addPoint(n - 5, 1);
        polygon.addPoint(n + 6, 1);
        polygon.addPoint(n + 1, 9);
        graphics.fillPolygon(polygon);
        graphics.drawLine(n, 5, n, this.height);
    }

    void insCameraKey() {
        camTime camTime2 = (camTime)this.film.camVec.elementAt(this.film.activeCameraN);
        Camera camera = (Camera)camTime2.camVec.elementAt(0);
        if (this.time < camera.timePosition) {
            this.film.selectedCamera = new Camera(this.time, camera, camera);
            camTime2.camVec.insertElementAt(this.film.selectedCamera, 0);
            this.film.tell();
            return;
        }
        int n = 0;
        while (n < camTime2.camVec.size()) {
            camera = (Camera)camTime2.camVec.elementAt(n);
            if (!(this.time > camera.timePosition)) {
                Camera camera2 = camera;
                if (n < camTime2.camVec.size() - 1) {
                    camera2 = (Camera)camTime2.camVec.elementAt(0);
                }
                this.film.selectedCamera = new Camera(this.time, camera, camera2);
                camTime2.camVec.insertElementAt(this.film.selectedCamera, n);
                this.film.tell();
                return;
            }
            ++n;
        }
        this.film.selectedCamera = new Camera(this.time, camera, camera);
        camTime2.camVec.insertElementAt(this.film.selectedCamera, n);
        this.film.tell();
    }

    void deleteCameraKey() {
        camTime camTime2 = (camTime)this.film.camVec.elementAt(this.film.activeCameraN);
        if (camTime2.camVec.size() > 1) {
            camTime2.camVec.removeElement(this.film.selectedCamera);
            this.selectCameraKey(this.time);
            this.film.tell();
        }
    }

    void selectCameraKey(double d) {
        camTime camTime2 = (camTime)this.film.camVec.elementAt(this.film.activeCameraN);
        double d2 = 1.1;
        int n = camTime2.camVec.size() - 1;
        while (n >= 0) {
            Camera camera = (Camera)camTime2.camVec.elementAt(n);
            double d3 = Math.abs(d - camera.timePosition);
            if (d3 < d2) {
                this.film.selectedCamera = camera;
                d2 = d3;
            }
            --n;
        }
        this.repaint();
    }
}

