/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.io.File;

public class Render
extends Dialog
implements Runnable {
    public static final int R_STOP = 0;
    public static final int R_RENDER = 1;
    public static final int R_CLOSE = 2;
    public static final int R_Files = 3;
    long startTime;
    int frameCount;
    FileDialog fd;
    Panel parPanel = new Panel();
    Panel parPanel1 = new Panel();
    Thread renderThread;
    long lastTime;
    renderButton rButton;
    renderButton stopButton;
    GUI gui;
    int action = 0;
    Label frameNumLabel;
    Label waitLabel;
    Label lastLabel;
    boolean offLine = false;
    boolean withFields = true;
    boolean antialising = true;
    boolean alfa = true;
    Checkbox fieldBox;
    Checkbox aaBox;
    Checkbox loopBox;
    Checkbox alfaBox;
    fieldChoice fieldchoice;
    TextField dirNameField;
    TextField baseNameField;
    renderIntPar widthPanel;
    renderIntPar heightPanel;
    renderIntPar startPanel;
    renderIntPar stopPanel;
    int startN;
    int stopN;
    int tgaWidth = 752;
    int tgaHeight = 576;
    Targa tga;
    statusBar tgaReady;
    Film film;
    String fileName;
    String renderName;
    int cnt;
    int cntMax;
    int nFrame;
    int keyDur;

    public Render(Frame frame, Film film, String string) {
        super(frame, String.valueOf(string) + " - targa sequence rendering ", true);
        this.film = film;
        this.fileName = string;
        this.offLine = true;
        this.renderName = this.makeRenderName(string);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 4));
        panel.add(new Label("Render # ", 2));
        this.frameNumLabel = new Label("   ", 0);
        panel.add(this.frameNumLabel);
        this.frameNumLabel.setFont(new Font("Helvetica", 1, 18));
        panel.add(new Label("Last ", 2));
        this.lastLabel = new Label("__m __s  ", 0);
        panel.add(this.lastLabel);
        this.lastLabel.setFont(new Font("Helvetica", 1, 14));
        panel.add(new Label("Wait ", 2));
        this.waitLabel = new Label("__m __s  ", 0);
        panel.add(this.waitLabel);
        this.waitLabel.setFont(new Font("Helvetica", 1, 14));
        panel.add(new renderButton("Close", this, 2));
        this.add("Center", panel);
        ((Component)this).setLocation(200, 10);
        ((Component)this).setSize(401, 80);
        this.show();
        this.OffLineStart();
    }

    public void open(String string) {
        System.out.print("Render=" + string + "   ");
        System.out.println(String.valueOf(this.film.renderWidth) + " X " + this.film.renderHeight);
        if (!string.equals(this.fileName)) {
            this.fileName = string;
            String string2 = this.makeRenderName(this.fileName);
            ((TextComponent)this.dirNameField).setText(string2);
            ((TextComponent)this.baseNameField).setText(string2);
        }
        this.startPanel.setValue(this.film.startKadrN, 0, this.film.duration() - 1);
        this.stopPanel.setValue(this.film.stopKadrN, 1, this.film.duration());
        this.widthPanel.setValue(this.film.renderWidth);
        this.heightPanel.setValue(this.film.renderHeight);
        this.fieldchoice.set();
        if (this.tgaReady != null) {
            this.tgaReady.set(0.0);
        }
        ((Component)this).setVisible(true);
    }

    public Render(GUI gUI, Film film, String string, boolean bl, boolean bl2) {
        super(gUI, "Tchiba: targa sequence rendering", true);
        this.gui = gUI;
        this.film = film;
        this.offLine = bl2;
        new renderService(this);
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(new GridLayout(10, 1));
        Panel panel = new Panel();
        this.waitLabel = new Label("Time output: ", 1);
        panel.add(this.waitLabel);
        this.startPanel = new renderIntPar(film, "Range:", film.startKadrN, 0, film.duration() - 1);
        panel.add(this.startPanel);
        this.stopPanel = new renderIntPar(film, "To", film.stopKadrN, 1, film.duration());
        panel.add(this.stopPanel);
        this.add(panel);
        if (bl) {
            this.withFields = false;
            this.antialising = false;
            this.tgaWidth = 160;
            this.tgaHeight = 120;
        }
        panel = new Panel();
        panel.setLayout(new GridLayout(1, 3));
        this.widthPanel = new renderIntPar(film, "Width", film.renderWidth, 120, 2400);
        this.heightPanel = new renderIntPar(film, "Height", film.renderHeight, 90, 1800);
        panel.add(this.widthPanel);
        SizeButton sizeButton = new SizeButton(360, 288, this.widthPanel, this.heightPanel);
        panel.add(sizeButton);
        sizeButton = new SizeButton(384, 288, this.widthPanel, this.heightPanel);
        panel.add(sizeButton);
        this.add(panel);
        panel = new Panel();
        panel.setLayout(new GridLayout(1, 3));
        panel.add(this.heightPanel);
        sizeButton = new SizeButton(720, 576, this.widthPanel, this.heightPanel);
        panel.add(sizeButton);
        sizeButton = new SizeButton(752, 576, this.widthPanel, this.heightPanel);
        panel.add(sizeButton);
        this.add(panel);
        this.parPanel = new Panel();
        this.parPanel.add(new Panel());
        this.parPanel.setLayout(new GridLayout(1, 3));
        this.parPanel.add(new Label("Field Render: ", 2));
        this.fieldchoice = new fieldChoice(film);
        this.parPanel.add(this.fieldchoice);
        this.add(this.parPanel);
        this.parPanel1 = new Panel();
        this.parPanel1.add(new Panel());
        this.parPanel1.setLayout(new GridLayout(1, 3));
        this.aaBox = new Checkbox("antialising", this.antialising);
        this.parPanel1.add(this.aaBox);
        this.alfaBox = new Checkbox("Render alpha", this.alfa);
        this.parPanel1.add(this.alfaBox);
        this.add(this.parPanel1);
        panel = new Panel();
        panel.add(new Label("Output dir:", 2));
        this.fd = new FileDialog((Frame)gUI, "Output dir");
        this.fd.setMode(1);
        String string2 = this.makeRenderName(string);
        if (bl) {
            this.dirNameField = new TextField(string2, 24);
            panel.add(this.dirNameField);
        } else {
            this.dirNameField = new TextField("Final", 24);
            panel.add(this.dirNameField);
        }
        this.add(panel);
        panel = new Panel();
        panel.add(new Label("Base name:", 2));
        this.baseNameField = new TextField(string2, 8);
        panel.add(this.baseNameField);
        panel.add(new renderButton("Files...", this, 3));
        this.add(panel);
        panel = new Panel();
        panel.setLayout(new GridLayout(1, 7));
        panel.add(new Label("Render", 1));
        this.frameNumLabel = new Label("   ", 1);
        panel.add(this.frameNumLabel);
        this.frameNumLabel.setFont(new Font("Helvetica", 1, 12));
        panel.add(new Label(" spent ", 1));
        this.lastLabel = new Label("           ", 1);
        panel.add(this.lastLabel);
        this.lastLabel.setFont(new Font("Helvetica", 1, 12));
        panel.add(new Label("Wait about", 1));
        this.waitLabel = new Label("           ", 1);
        panel.add(this.waitLabel);
        this.waitLabel.setFont(new Font("Helvetica", 1, 12));
        this.add(panel);
        this.tgaReady = new statusBar();
        this.add(this.tgaReady);
        panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.rButton = new renderButton("Render", this, 1);
        panel.add(this.rButton);
        this.stopButton = new renderButton("Stop", this, 0);
        panel.add(this.stopButton);
        this.stopButton.setEnabled(false);
        panel.add(new renderButton("Close", this, 2));
        this.add(panel);
        ((Component)this).setLocation(200, 80);
        ((Component)this).setSize(405, 405);
    }

    String makeRenderName(String string) {
        String string2;
        int n = string.indexOf(46);
        string.indexOf(32);
        try {
            string2 = string.substring(0, n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            string2 = "aaaa";
        }
        return string2;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        if (this.tgaReady != null) {
            this.tgaReady.set(0.0);
        }
        if (this.renderThread != null) {
            this.stop();
        }
        if (this.offLine) {
            this.OffLineStart();
            return;
        }
        this.withFields = this.film.renderFields;
        this.antialising = this.aaBox.getState();
        this.alfa = this.alfaBox.getState();
        String string = this.dirNameField.getText();
        File file = new File(string);
        file.mkdir();
        this.tgaWidth = this.film.renderWidth;
        this.tgaHeight = this.film.renderHeight;
        this.startN = this.startPanel.intValue();
        this.stopN = this.stopPanel.intValue();
        int n = this.startN;
        if (n > 0) {
            ++n;
        }
        if (this.tga != null) {
            this.tga.dispose();
        }
        this.tga = new Targa(this.tgaWidth, this.tgaHeight, this.withFields, this.film.lowerFieldFirst, String.valueOf(this.dirNameField.getText()) + File.separator + this.baseNameField.getText(), n, this.antialising, this.alfa);
        Camera.mode = 0;
        this.parPanel.setEnabled(false);
        this.parPanel1.setEnabled(false);
        this.rButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        this.frameCount = this.startN;
        this.renderThread = new Thread(this);
        this.renderThread.start();
    }

    void OffLineStart() {
        this.withFields = true;
        this.antialising = true;
        this.alfa = true;
        File file = new File("Final");
        file.mkdir();
        this.tgaWidth = 752;
        this.tgaHeight = 576;
        int n = this.film.startKadrN;
        if (n > 0) {
            ++n;
        }
        this.tga = new Targa(this.tgaWidth, this.tgaHeight, this.withFields, this.film.lowerFieldFirst, "Final" + File.separator + this.renderName, n, this.antialising, this.alfa);
        Camera.mode = 0;
        this.frameCount = this.film.startKadrN;
        this.renderThread = new Thread(this);
        this.renderThread.start();
    }

    public void stop() {
        if (!this.offLine) {
            this.parPanel.setEnabled(true);
            this.parPanel1.setEnabled(true);
            this.rButton.setEnabled(true);
            this.stopButton.setEnabled(false);
        }
        if (this.renderThread != null) {
            this.renderThread.stop();
            this.renderThread = null;
        }
    }

    public void run() {
        OffScreen offScreen = this.makeDoubleBuffer(this.tgaWidth, this.tgaHeight);
        OffScreen offScreen2 = null;
        if (this.withFields) {
            offScreen2 = this.makeDoubleBuffer(this.tgaWidth, this.tgaHeight);
        }
        while (true) {
            offScreen.clear();
            this.lastTime = this.startTime = System.currentTimeMillis();
            int n = this.tgaWidth;
            int n2 = this.tgaHeight;
            Camera.screenWidth = n;
            Camera.screenX0 = (double)n / 2.0;
            Camera.screenY0 = (double)n2 / 2.0;
            this.frameNumLabel.setText(Integer.toString(this.frameCount + 1));
            Camera camera = this.film.tmpCamera(this.frameCount, 0.0);
            camera.set();
            Camera.mode = 0;
            this.film.paint(offScreen.GC, this.frameCount, 0.0);
            if (this.withFields) {
                offScreen2.clear();
                camera = this.film.tmpCamera(this.frameCount, 0.5);
                camera.set();
                this.film.paint(offScreen2.GC, this.frameCount, 0.5);
            }
            if (this.frameCount == 0) {
                this.tga.grab(this.tgaWidth, this.tgaHeight, offScreen.image);
                this.lastTime = this.startTime;
            }
            if (this.withFields) {
                this.tga.grab(this.tgaWidth, this.tgaHeight, offScreen.image, offScreen2.image);
                this.tgaReady.set(((double)(this.frameCount - this.startN) + 0.5) / (double)(this.stopN - this.startN));
            } else {
                this.tga.grab(this.tgaWidth, this.tgaHeight, offScreen.image);
            }
            if (this.frameCount == this.film.duration() - 1) {
                if (this.withFields) {
                    this.tga.grab(this.tgaWidth, this.tgaHeight, offScreen2.image);
                } else {
                    this.tga.grab(this.tgaWidth, this.tgaHeight, offScreen.image);
                }
            }
            ++this.frameCount;
            long l = System.currentTimeMillis();
            double d = (double)(l - this.lastTime) / 1000.0;
            this.lastTime = l;
            double d2 = d * (double)(this.stopN - this.frameCount);
            int n3 = (int)d2 / 60;
            int n4 = (int)d2 % 60;
            this.lastLabel.setText(String.valueOf((int)d) + "s");
            if (n3 > 5) {
                this.waitLabel.setText(String.valueOf(n3) + "m " + n4 + "s");
            } else {
                this.waitLabel.setText(String.valueOf(n3) + "m " + n4 + "s");
            }
            this.tgaReady.set((double)(this.frameCount - this.startN) / (double)(this.stopN - this.startN));
            if (this.frameCount >= this.film.duration() || this.frameCount >= this.stopN) {
                if (this.tgaReady != null) {
                    this.tgaReady.set("Rendering complete", 1.0);
                }
                offScreen.image.flush();
                offScreen = null;
                if (offScreen2 != null) {
                    offScreen2.image.flush();
                    offScreen2 = null;
                }
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                toolkit.beep();
                if (this.offLine) {
                    System.out.println(String.valueOf(this.fileName) + " - Rendering complete.");
                    System.exit(0);
                }
                this.stop();
            }
            if (this.renderThread == null) continue;
            Thread.yield();
        }
    }

    OffScreen makeDoubleBuffer(int n, int n2) {
        Image image = this.createImage(n, n2);
        return new OffScreen(new Dimension(n, n2), image);
    }
}

