/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Observable;
import java.util.Observer;

class RGBField
extends Panel
implements Observer,
AdjustmentListener {
    String name;
    ColorSetting colorSetting;
    Scrollbar slider;
    Label v;

    RGBField(ColorSetting colorSetting, String string) {
        this.name = string;
        this.colorSetting = colorSetting;
        this.setLayout(new GridLayout(2, 1));
        int n = colorSetting.getRGB(this.name);
        this.v = new Label(String.valueOf(this.name) + ": " + new Integer(n).toString());
        this.add(this.v);
        this.slider = new Scrollbar(0, colorSetting.getRGB(string), 0, 0, 256);
        this.add(this.slider);
        this.slider.addAdjustmentListener(this);
        colorSetting.addObserver(this);
    }

    public void update(Observable observable, Object object) {
        ColorSetting colorSetting = (ColorSetting)object;
        int n = colorSetting.getRGB(this.name);
        this.slider.setValue(n);
        this.v.setText(String.valueOf(this.name) + ": " + new Integer(n).toString());
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        this.colorSetting.setRGB(this.name, n);
    }
}

