/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Observable;
import java.util.Observer;

class HSBField
extends Panel
implements Observer,
AdjustmentListener {
    String name;
    ColorSetting colorSetting;
    Scrollbar slider;
    final int KOEF = 1000;

    HSBField(ColorSetting colorSetting, String string) {
        this.name = string;
        this.colorSetting = colorSetting;
        this.setLayout(new GridLayout(2, 1));
        this.add(new Label(String.valueOf(this.name) + ":"));
        this.slider = new Scrollbar(0, (int)(1000.0f * colorSetting.getHSB(string)), 0, 0, 1001);
        this.add(this.slider);
        this.slider.addAdjustmentListener(this);
        colorSetting.addObserver(this);
    }

    public void update(Observable observable, Object object) {
        ColorSetting colorSetting = (ColorSetting)object;
        int n = (int)(1000.0f * colorSetting.getHSB(this.name));
        if (n != this.slider.getValue()) {
            this.slider.setValue(n);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        float f = (float)adjustmentEvent.getValue() / 1000.0f;
        this.colorSetting.setHSB(this.name, f);
    }
}

