/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Observable;

class ColorSetting
extends Observable {
    private Color col;

    ColorSetting() {
        this.col = new Color(0, 0, 0);
    }

    ColorSetting(Color color) {
        this.col = color;
    }

    public void setRed(int n) {
        this.col = new Color(n, this.col.getGreen(), this.col.getBlue());
    }

    public void setGreen(int n) {
        this.col = new Color(this.col.getRed(), n, this.col.getBlue());
    }

    public void setBlue(int n) {
        this.col = new Color(this.col.getRed(), this.col.getGreen(), n);
    }

    public void setColor(Color color) {
        this.col = color;
        this.tell();
    }

    public int getRGB(String string) {
        if (string.equals("R")) {
            return this.col.getRed();
        }
        if (string.equals("G")) {
            return this.col.getGreen();
        }
        if (string.equals("B")) {
            return this.col.getBlue();
        }
        return 0;
    }

    public void setRGB(String string, int n) {
        if (string.equals("R")) {
            this.setRed(n);
        }
        if (string.equals("G")) {
            this.setGreen(n);
        }
        if (string.equals("B")) {
            this.setBlue(n);
        }
        this.tell();
    }

    public float getHSB(String string) {
        if (string.equals("H")) {
            return Color.RGBtoHSB(this.col.getRed(), this.col.getGreen(), this.col.getBlue(), null)[0];
        }
        if (string.equals("S")) {
            return Color.RGBtoHSB(this.col.getRed(), this.col.getGreen(), this.col.getBlue(), null)[1];
        }
        if (string.equals("B")) {
            return Color.RGBtoHSB(this.col.getRed(), this.col.getGreen(), this.col.getBlue(), null)[2];
        }
        return 0.0f;
    }

    public void setHSB(String string, float f) {
        float[] fArray = Color.RGBtoHSB(this.col.getRed(), this.col.getGreen(), this.col.getBlue(), null);
        if (string.equals("H")) {
            this.col = Color.getHSBColor(f, fArray[1], fArray[2]);
        }
        if (string.equals("S")) {
            this.col = Color.getHSBColor(fArray[0], f, fArray[2]);
        }
        if (string.equals("B")) {
            this.col = Color.getHSBColor(fArray[0], fArray[1], f);
        }
        this.tell();
    }

    void tell() {
        this.setChanged();
        this.notifyObservers(this);
    }

    public Color getColor() {
        return this.col;
    }
}

