/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class ChShape
implements Serializable {
    int selectedPointN;
    boolean hidden;
    public Vector pointVector = new Vector();
    static int iPoint;
    static Vector drawPoint;
    static int xlast;
    static int ylast;

    ChShape() {
        this.pointVector = new Vector();
    }

    ChShape(ChShape chShape) {
        this.hidden = chShape.hidden;
        this.selectedPointN = chShape.selectedPointN;
        Enumeration enumeration = chShape.pointVector.elements();
        while (enumeration.hasMoreElements()) {
            shapePoint shapePoint2 = new shapePoint((shapePoint)enumeration.nextElement());
            this.pointVector.addElement(shapePoint2);
        }
    }

    ChShape(double d, ChShape chShape, ChShape chShape2) {
        this.hidden = chShape.hidden;
        int n = chShape.pointVector.size();
        int n2 = 0;
        while (n2 < n) {
            shapePoint shapePoint2 = (shapePoint)chShape.pointVector.elementAt(n2);
            shapePoint shapePoint3 = (shapePoint)chShape2.pointVector.elementAt(n2);
            shapePoint shapePoint4 = new shapePoint(d, shapePoint2, shapePoint3);
            this.pointVector.addElement(shapePoint4);
            ++n2;
        }
    }

    void getPosition(ChShape chShape) {
        this.selectedPointN = chShape.selectedPointN;
        this.pointVector.removeAllElements();
        int n = 0;
        while (n < chShape.pointVector.size()) {
            shapePoint shapePoint2 = new shapePoint((shapePoint)chShape.pointVector.elementAt(n));
            this.pointVector.addElement(shapePoint2);
            ++n;
        }
    }

    void plotPoints(Graphics graphics) {
        int n = this.pointVector.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(n2);
            double d = shapePoint2.x[1];
            int n3 = (int)(Camera.screenX0 + (d - Camera.actualX0) * Camera.actualZoom);
            d = shapePoint2.y[1];
            int n4 = (int)(Camera.screenY0 + (d - Camera.actualY0) * Camera.actualZoom);
            if (n2 == 0) {
                Polygon polygon = new Polygon();
                polygon.addPoint(n3 - 4, n4);
                polygon.addPoint(n3, n4 - 4);
                polygon.addPoint(n3 + 4, n4);
                polygon.addPoint(n3, n4 + 4);
                graphics.setColor(Color.white);
                graphics.fillPolygon(polygon);
                polygon.addPoint(n3 - 4, n4);
                polygon.addPoint(n3 + 4, n4);
                polygon.addPoint(n3, n4 - 4);
                polygon.addPoint(n3, n4 + 4);
                graphics.setColor(Color.black);
                graphics.fillPolygon(polygon);
            } else {
                graphics.setColor(Color.darkGray);
                graphics.fillOval(n3 - 2, n4 - 2, 5, 5);
                graphics.setColor(Color.white);
                graphics.fillOval(n3 - 1, n4 - 1, 3, 3);
            }
            ++n2;
        }
    }

    boolean visible() {
        int n = (int)(2.0 * Camera.screenX0);
        int n2 = (int)(2.0 * Camera.screenY0);
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        Polygon polygon = new Polygon();
        int n3 = 0;
        while (n3 < this.pointVector.size()) {
            shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(n3);
            int n4 = 0;
            while (n4 < 3) {
                double d = shapePoint2.x[n4];
                int n5 = (int)(Camera.screenX0 + (d - Camera.actualX0) * Camera.actualZoom);
                int n6 = (int)(Camera.screenY0 + ((d = shapePoint2.y[n4]) - Camera.actualY0) * Camera.actualZoom);
                if (rectangle.contains(n5, n6)) {
                    return true;
                }
                polygon.addPoint(n5, n6);
                ++n4;
            }
            ++n3;
        }
        if (polygon.contains(0, 0)) {
            return true;
        }
        if (polygon.contains(0, n2)) {
            return true;
        }
        if (polygon.contains(n, 0)) {
            return true;
        }
        return polygon.contains(n, n2);
    }

    void plot(Graphics graphics, shapeHeader shapeHeader2) {
        int n = this.pointVector.size();
        if (n < 2) {
            return;
        }
        if (this.hidden || !this.visible()) {
            return;
        }
        Polygon polygon = new Polygon();
        shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(1);
        int n2 = 1;
        int n3 = 2;
        while (n3 <= n) {
            int n4 = n3;
            if (n4 == n) {
                n4 = 1;
            }
            shapePoint shapePoint3 = (shapePoint)this.pointVector.elementAt(n4);
            double d = shapePoint2.x[1];
            int n5 = (int)(Camera.screenX0 + (d - Camera.actualX0) * Camera.actualZoom);
            double d2 = shapePoint2.y[1];
            int n6 = (int)(Camera.screenY0 + (d2 - Camera.actualY0) * Camera.actualZoom);
            polygon.addPoint(n5, n6);
            if (!shapeHeader2.getLinear()) {
                int n7 = (int)((Math.abs(shapePoint2.x[1] - shapePoint2.x[2]) + Math.abs(shapePoint2.y[1] - shapePoint2.y[2]) + Math.abs(shapePoint2.x[2] - shapePoint3.x[0]) + Math.abs(shapePoint2.y[2] - shapePoint3.y[0]) + Math.abs(shapePoint3.x[0] - shapePoint3.x[1]) + Math.abs(shapePoint3.y[0] - shapePoint3.y[1])) * Camera.actualZoom);
                n2 = 64;
                while (n7 > 4 && n2 > 2) {
                    n7 /= 4;
                    n2 /= 2;
                }
                int n8 = 1;
                while (n8 < 64) {
                    double d3 = Besye.point(n8, shapePoint2.x[1], shapePoint2.x[2], shapePoint3.x[0], shapePoint3.x[1]);
                    double d4 = Besye.point(n8, shapePoint2.y[1], shapePoint2.y[2], shapePoint3.y[0], shapePoint3.y[1]);
                    int n9 = (int)(Camera.screenX0 + (d3 - Camera.actualX0) * Camera.actualZoom);
                    int n10 = (int)(Camera.screenY0 + (d4 - Camera.actualY0) * Camera.actualZoom);
                    polygon.addPoint(n9, n10);
                    n8 += n2;
                }
            }
            shapePoint2 = shapePoint3;
            ++n3;
        }
        if (Camera.mode == 2) {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.black);
            graphics.drawPolygon(polygon);
            graphics.setPaintMode();
            return;
        }
        if (shapeHeader2.filled) {
            Color color = this.checkedColor(shapeHeader2.fillColor);
            graphics.setColor(color);
            graphics.fillPolygon(polygon);
        }
        if (shapeHeader2.type != 0) {
            if (Camera.mode == 0) {
                this.plotGradient(graphics, shapeHeader2);
            } else {
                Color color = this.checkedColor(shapeHeader2.fillColor);
                graphics.setColor(color);
                graphics.drawPolygon(polygon);
            }
        }
        if (shapeHeader2.bordered) {
            Color color = this.checkedColor(shapeHeader2.borderColor);
            graphics.setColor(color);
            if (Camera.mode == 1) {
                if (shapeHeader2.getClosed()) {
                    graphics.drawPolygon(polygon);
                    return;
                }
                graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints - 64 / n2);
                return;
            }
            this.plotBorder(graphics, shapeHeader2, polygon);
        }
    }

    void plot(Graphics graphics) {
        shapePoint shapePoint2;
        int n;
        int n2 = this.pointVector.size();
        if (n2 < 2) {
            return;
        }
        Polygon polygon = new Polygon();
        shapePoint shapePoint3 = (shapePoint)this.pointVector.elementAt(1);
        int n3 = 2;
        while (n3 <= n2) {
            n = n3;
            if (n == n2) {
                n = 1;
            }
            shapePoint2 = (shapePoint)this.pointVector.elementAt(n);
            int n4 = 0;
            while (n4 < 64) {
                double d = Besye.point(n4, shapePoint3.x[1], shapePoint3.x[2], shapePoint2.x[0], shapePoint2.x[1]);
                double d2 = Besye.point(n4, shapePoint3.y[1], shapePoint3.y[2], shapePoint2.y[0], shapePoint2.y[1]);
                int n5 = (int)(Camera.screenX0 + (d - Camera.actualX0) * Camera.actualZoom);
                int n6 = (int)(Camera.screenY0 + (d2 - Camera.actualY0) * Camera.actualZoom);
                polygon.addPoint(n5, n6);
                ++n4;
            }
            shapePoint3 = shapePoint2;
            ++n3;
        }
        graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints - 64);
        shapePoint3 = (shapePoint)this.pointVector.elementAt(n2 - 1);
        shapePoint2 = (shapePoint)this.pointVector.elementAt(1);
        n = 1;
        while (n < 64) {
            double d = Besye.point(n - 1, shapePoint3.x[1], shapePoint3.x[2], shapePoint2.x[0], shapePoint2.x[1]);
            double d3 = Besye.point(n - 1, shapePoint3.y[1], shapePoint3.y[2], shapePoint2.y[0], shapePoint2.y[1]);
            double d4 = Besye.point(n, shapePoint3.x[1], shapePoint3.x[2], shapePoint2.x[0], shapePoint2.x[1]);
            double d5 = Besye.point(n, shapePoint3.y[1], shapePoint3.y[2], shapePoint2.y[0], shapePoint2.y[1]);
            int n7 = (int)(Camera.screenX0 + (d - Camera.actualX0) * Camera.actualZoom);
            int n8 = (int)(Camera.screenY0 + (d3 - Camera.actualY0) * Camera.actualZoom);
            int n9 = (int)(Camera.screenX0 + (d4 - Camera.actualX0) * Camera.actualZoom);
            int n10 = (int)(Camera.screenY0 + (d5 - Camera.actualY0) * Camera.actualZoom);
            graphics.drawLine(n7, n8, n9, n10);
            n += 3;
        }
    }

    void plotGradient(Graphics graphics, shapeHeader shapeHeader2) {
        int n = this.pointVector.size();
        if (n < 2) {
            return;
        }
        int n2 = this.pointVector.size() - 1;
        int n3 = n2 / 2 + n2 % 2;
        shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(1);
        shapePoint shapePoint3 = (shapePoint)this.pointVector.elementAt(n3);
        shapePoint shapePoint4 = (shapePoint)this.pointVector.elementAt(n2 - n3 + 1);
        shapePoint shapePoint5 = (shapePoint)this.pointVector.elementAt(n2);
        Polygon polygon = new Polygon();
        boolean bl = false;
        int n4 = 0;
        double d = 0.0;
        if (shapeHeader2.getBrush()) {
            d = (double)shapeHeader2.bWidth * 1.2;
        }
        while (n4 <= 64) {
            int n5;
            Serializable serializable;
            double d2;
            double d3;
            double d4;
            double d5;
            if (shapeHeader2.getLinear()) {
                d5 = shapePoint2.x[1];
                d4 = shapePoint5.x[1];
                d3 = d5 * Besye.ts[n4] + d4 * Besye.tf[n4];
                d5 = shapePoint2.y[1];
                d4 = shapePoint5.y[1];
                d2 = d5 * Besye.ts[n4] + d4 * Besye.tf[n4];
            } else {
                d3 = Besye.point(n4, shapePoint2.x[1], shapePoint2.x[0], shapePoint5.x[2], shapePoint5.x[1], d);
                d2 = Besye.point(n4, shapePoint2.y[1], shapePoint2.y[0], shapePoint5.y[2], shapePoint5.y[1], d);
            }
            d5 = (double)n4 / 64.0;
            d4 = Math.sin(d5 * Math.PI);
            Math.cos(d5 * Math.PI / 2.0);
            double d6 = 0.6 + 0.4 * d4;
            double d7 = 1.4 - 0.4 * d4;
            double d8 = shapePoint2.x[2] + (shapePoint5.x[0] - shapePoint2.x[2]) * d5;
            double d9 = shapePoint2.y[2] + (shapePoint5.y[0] - shapePoint2.y[2]) * d5;
            boolean bl2 = false;
            if (shapeHeader2.pixels != null) {
                bl2 = true;
            }
            Vector<shapePoint> vector = new Vector<shapePoint>();
            shapePoint shapePoint6 = new shapePoint(d8, d9, d3, d2, d8, d9);
            vector.addElement(shapePoint6);
            int n6 = 2;
            while (n6 < n3) {
                int n7 = n2 - n6 + 1;
                shapePoint shapePoint7 = (shapePoint)this.pointVector.elementAt(n6);
                shapePoint shapePoint8 = (shapePoint)this.pointVector.elementAt(n7);
                shapePoint6 = new shapePoint(shapePoint7.x[0] + (shapePoint8.x[2] - shapePoint7.x[0]) * d5, shapePoint7.y[0] + (shapePoint8.y[2] - shapePoint7.y[0]) * d5, shapePoint7.x[1] + (shapePoint8.x[1] - shapePoint7.x[1]) * d5, shapePoint7.y[1] + (shapePoint8.y[1] - shapePoint7.y[1]) * d5, shapePoint7.x[2] + (shapePoint8.x[0] - shapePoint7.x[2]) * d5, shapePoint7.y[2] + (shapePoint8.y[0] - shapePoint7.y[2]) * d5);
                if (!bl) {
                    vector.addElement(shapePoint6);
                } else {
                    shapePoint6.revers();
                    vector.insertElementAt(shapePoint6, 0);
                }
                ++n6;
            }
            if (shapeHeader2.getLinear()) {
                double d10 = shapePoint3.x[1];
                double d11 = shapePoint4.x[1];
                d3 = d10 * Besye.ts[n4] + d11 * Besye.tf[n4];
                d10 = shapePoint3.y[1];
                d11 = shapePoint4.y[1];
                d2 = d10 * Besye.ts[n4] + d11 * Besye.tf[n4];
            } else {
                d3 = Besye.point(n4, shapePoint3.x[1], shapePoint3.x[2], shapePoint4.x[0], shapePoint4.x[1], d);
                d2 = Besye.point(n4, shapePoint3.y[1], shapePoint3.y[2], shapePoint4.y[0], shapePoint4.y[1], d);
            }
            d8 = shapePoint3.x[0] + (shapePoint4.x[2] - shapePoint3.x[0]) * d5;
            d9 = shapePoint3.y[0] + (shapePoint4.y[2] - shapePoint3.y[0]) * d5;
            shapePoint6 = new shapePoint(d8, d9, d3, d2, d8, d9);
            if (!bl) {
                vector.addElement(shapePoint6);
            } else {
                vector.insertElementAt(shapePoint6, 0);
            }
            n = vector.size();
            Serializable serializable2 = (shapePoint)vector.elementAt(0);
            int n8 = 1;
            if (shapeHeader2.getLinear()) {
                n8 = 64;
            }
            int n9 = 1;
            while (n9 < n) {
                serializable = (shapePoint)vector.elementAt(n9);
                int n10 = 0;
                while (n10 <= 64) {
                    double d12 = Besye.point(n10, serializable2.x[1], serializable2.x[2], ((shapePoint)serializable).x[0], ((shapePoint)serializable).x[1], d);
                    double d13 = Besye.point(n10, serializable2.y[1], serializable2.y[2], ((shapePoint)serializable).y[0], ((shapePoint)serializable).y[1], d);
                    n5 = (int)(Camera.screenX0 + (d12 - Camera.actualX0) * Camera.actualZoom);
                    int n11 = (int)(Camera.screenY0 + (d13 - Camera.actualY0) * Camera.actualZoom);
                    polygon.addPoint(n5, n11);
                    n10 += n8;
                }
                serializable2 = serializable;
                ++n9;
            }
            if (bl) {
                boolean bl3;
                Serializable serializable3;
                float f;
                serializable = shapeHeader2.borderColor;
                Color color = shapeHeader2.fillColor;
                if (((Color)serializable).equals(Color.black)) {
                    serializable = new Color(2, 2, 2);
                }
                if (color.equals(Color.black)) {
                    color = new Color(2, 2, 2);
                }
                if (shapeHeader2.type == 1) {
                    float f2;
                    float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                    f = (float)((double)fArray[1] * (d5 / 4.0 + 1.0));
                    if ((double)f > 1.0) {
                        f = 1.0f;
                    }
                    if ((double)(f2 = (float)((double)fArray[2] * (1.0 - d5 / 2.0))) > 1.0) {
                        f2 = 1.0f;
                    }
                    if ((double)f2 < 0.0) {
                        f2 = 0.0f;
                    }
                    serializable3 = Color.getHSBColor(fArray[0], f, f2);
                    graphics.setColor((Color)serializable3);
                }
                if (shapeHeader2.type == 2) {
                    float f3;
                    float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                    f = (float)((double)fArray[1] * (-d5 * 0.8 + 1.0));
                    if ((double)f < 0.0) {
                        f = 0.0f;
                    }
                    if ((double)(f3 = (float)((double)fArray[2] * (1.0 + d5 / 4.0))) > 1.0) {
                        f3 = 1.0f;
                    }
                    if ((double)f3 < 0.0) {
                        f3 = 0.0f;
                    }
                    serializable3 = Color.getHSBColor(fArray[0], f, f3);
                    graphics.setColor((Color)serializable3);
                }
                if (shapeHeader2.type == 5) {
                    float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                    f = (float)((double)fArray[1] * d7);
                    if ((double)f > 1.0) {
                        d7 = 1.0 / (double)f;
                        f = 1.0f;
                    }
                    Color color2 = Color.getHSBColor(fArray[0], f, (float)((double)fArray[2] * d6));
                    graphics.setColor(color2);
                }
                boolean bl4 = bl3 = n4 % (2 * shapeHeader2.bWidth) < shapeHeader2.bWidth;
                if (shapeHeader2.type == 3 || shapeHeader2.type == 4) {
                    if (bl3) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor((Color)serializable);
                    }
                }
                if (Camera.mode != 0) {
                    graphics.drawPolygon(polygon);
                } else if (!bl3 || shapeHeader2.type != 4) {
                    if (bl2) {
                        int n12 = polygon.npoints;
                        int n13 = 0;
                        while (n13 < n12 / 2) {
                            serializable3 = new Polygon();
                            ((Polygon)serializable3).addPoint(polygon.xpoints[n13], polygon.ypoints[n13]);
                            ((Polygon)serializable3).addPoint(polygon.xpoints[n13 + 1], polygon.ypoints[n13 + 1]);
                            ((Polygon)serializable3).addPoint(polygon.xpoints[n12 - n13 - 2], polygon.ypoints[n12 - n13 - 2]);
                            ((Polygon)serializable3).addPoint(polygon.xpoints[n12 - n13 - 1], polygon.ypoints[n12 - n13 - 1]);
                            n5 = shapeHeader2.pixels[n4 * 64 + n13] & 0xFFFFFF;
                            if (n5 > 0) {
                                Color color3 = new Color(n5);
                                graphics.setColor(color3);
                                graphics.fillPolygon((Polygon)serializable3);
                            }
                            ++n13;
                        }
                    } else {
                        graphics.fillPolygon(polygon);
                    }
                }
                polygon = new Polygon();
            } else {
                ++n4;
            }
            if (shapeHeader2.type == 3 || shapeHeader2.type == 4) {
                n4 += shapeHeader2.bWidth / 2;
            }
            if (shapeHeader2.type == 4) {
                n4 += shapeHeader2.bWidth / 2;
            }
            boolean bl5 = bl = !bl;
        }
    }

    Color RandomColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = (int)(20.0 * Math.random() * Math.random() * Math.random());
        if ((n += n4) > 255) {
            n = 255;
        }
        if ((n2 += n4) > 255) {
            n2 = 255;
        }
        if ((n3 += n4) > 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    void shiftSegment(double d, shapePoint shapePoint2, shapePoint shapePoint3) {
        int n = 1;
        double d2 = Besye.point(n, shapePoint2.x[1], shapePoint2.x[2], shapePoint3.x[0], shapePoint3.x[1]) - shapePoint2.x[1];
        double d3 = Besye.point(n, shapePoint2.y[1], shapePoint2.y[2], shapePoint3.y[0], shapePoint3.y[1]) - shapePoint2.y[1];
        double d4 = Math.sqrt(Math.pow(d2, 2.0) + Math.pow(d3, 2.0));
        n = 63;
        double d5 = -Besye.point(n, shapePoint2.x[1], shapePoint2.x[2], shapePoint3.x[0], shapePoint3.x[1]) + shapePoint3.x[1];
        double d6 = -Besye.point(n, shapePoint2.y[1], shapePoint2.y[2], shapePoint3.y[0], shapePoint3.y[1]) + shapePoint3.y[1];
        double d7 = Math.sqrt(Math.pow(d5, 2.0) + Math.pow(d6, 2.0));
        if (d4 > 0.0) {
            shapePoint2.x[1] = shapePoint2.x[1] + d * d3 / d4;
            shapePoint2.y[1] = shapePoint2.y[1] - d * d2 / d4;
            shapePoint2.x[2] = shapePoint2.x[2] + d * d3 / d4;
            shapePoint2.y[2] = shapePoint2.y[2] - d * d2 / d4;
        }
        if (d7 > 0.0) {
            shapePoint3.x[1] = shapePoint3.x[1] + d * d6 / d7;
            shapePoint3.y[1] = shapePoint3.y[1] - d * d5 / d7;
            shapePoint3.x[0] = shapePoint3.x[0] + d * d6 / d7;
            shapePoint3.y[0] = shapePoint3.y[0] - d * d5 / d7;
        }
    }

    Color checkedColor(Color color) {
        int n;
        int n2;
        int n3 = color.getRed();
        if (n3 < 10) {
            n3 = 10;
        }
        if ((n2 = color.getGreen()) < 10) {
            n2 = 10;
        }
        if ((n = color.getBlue()) < 10) {
            n = 10;
        }
        return new Color(n3, n2, n);
    }

    void plotBorder(Graphics graphics, shapeHeader shapeHeader2, Polygon polygon) {
        int n;
        int n2;
        int n3;
        int n4 = this.pointVector.size();
        double d = (double)shapeHeader2.bWidth / 2.0 + 0.5;
        double d2 = 0.5 + d - Math.sqrt(d);
        shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(1);
        int n5 = 1;
        Color color = this.checkedColor(shapeHeader2.borderColor);
        graphics.setColor(color);
        int n6 = 2;
        while (n6 <= n4) {
            int n7;
            int n8;
            double d3;
            double d4;
            n3 = n6;
            if (n3 == n4) {
                n3 = 1;
                if (!shapeHeader2.getClosed()) break;
            }
            Polygon polygon2 = new Polygon();
            shapePoint shapePoint3 = new shapePoint(shapePoint2);
            shapePoint shapePoint4 = (shapePoint)this.pointVector.elementAt(n3);
            shapePoint shapePoint5 = new shapePoint(shapePoint4);
            this.shiftSegment(d, shapePoint3, shapePoint5);
            if (shapeHeader2.getLinear()) {
                n5 = 64;
            }
            n2 = 0;
            while (n2 <= 64) {
                if (shapeHeader2.getBrush()) {
                    d4 = Besye.point(n2, shapePoint3.x[1], shapePoint3.x[2], shapePoint5.x[0], shapePoint5.x[1], d2);
                    d3 = Besye.point(n2, shapePoint3.y[1], shapePoint3.y[2], shapePoint5.y[0], shapePoint5.y[1], d2);
                } else {
                    d4 = Besye.point(n2, shapePoint3.x[1], shapePoint3.x[2], shapePoint5.x[0], shapePoint5.x[1]);
                    d3 = Besye.point(n2, shapePoint3.y[1], shapePoint3.y[2], shapePoint5.y[0], shapePoint5.y[1]);
                }
                n8 = (int)(Camera.screenX0 + (d4 - Camera.actualX0) * Camera.actualZoom);
                n7 = (int)(Camera.screenY0 + (d3 - Camera.actualY0) * Camera.actualZoom);
                polygon2.addPoint(n8, n7);
                n2 += n5;
            }
            shapePoint3 = new shapePoint(shapePoint4);
            shapePoint3.revers();
            shapePoint5 = new shapePoint(shapePoint2);
            shapePoint5.revers();
            this.shiftSegment(d, shapePoint3, shapePoint5);
            n = 0;
            while (n <= 64) {
                if (shapeHeader2.getBrush()) {
                    d4 = Besye.point(n, shapePoint3.x[1], shapePoint3.x[2], shapePoint5.x[0], shapePoint5.x[1], d2);
                    d3 = Besye.point(n, shapePoint3.y[1], shapePoint3.y[2], shapePoint5.y[0], shapePoint5.y[1], d2);
                } else {
                    d4 = Besye.point(n, shapePoint3.x[1], shapePoint3.x[2], shapePoint5.x[0], shapePoint5.x[1]);
                    d3 = Besye.point(n, shapePoint3.y[1], shapePoint3.y[2], shapePoint5.y[0], shapePoint5.y[1]);
                }
                n8 = (int)(Camera.screenX0 + (d4 - Camera.actualX0) * Camera.actualZoom);
                n7 = (int)(Camera.screenY0 + (d3 - Camera.actualY0) * Camera.actualZoom);
                polygon2.addPoint(n8, n7);
                n += n5;
            }
            graphics.fillPolygon(polygon2);
            shapePoint2 = shapePoint4;
            ++n6;
        }
        n3 = 1;
        while (n3 < n4) {
            shapePoint2 = (shapePoint)this.pointVector.elementAt(n3);
            double d5 = shapePoint2.x[1] - d;
            int n9 = (int)(Camera.screenX0 + (d5 - Camera.actualX0) * Camera.actualZoom);
            double d6 = shapePoint2.y[1] - d;
            n2 = (int)(Camera.screenY0 + (d6 - Camera.actualY0) * Camera.actualZoom);
            double d7 = shapePoint2.x[1] + d;
            n = (int)(Camera.screenX0 + (d7 - Camera.actualX0) * Camera.actualZoom);
            double d8 = shapePoint2.y[1] + d;
            int n10 = (int)(Camera.screenY0 + (d8 - Camera.actualY0) * Camera.actualZoom);
            graphics.fillOval(n9, n2, n - n9, n10 - n2);
            ++n3;
        }
    }

    public int distanse(MouseEvent mouseEvent) {
        int n = Integer.MAX_VALUE;
        int n2 = this.pointVector.size();
        int n3 = 0;
        while (n3 < n2) {
            shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(n3);
            int n4 = 1;
            while (n4 < 4) {
                int n5;
                int n6 = n4;
                if (n4 == 3) {
                    n6 = 0;
                }
                double d = shapePoint2.x[n6];
                int n7 = (int)(Camera.screenX0 + (d - Camera.actualX0) * Camera.actualZoom) - mouseEvent.getX();
                int n8 = n7 * n7 + (n5 = (int)(Camera.screenY0 + ((d = shapePoint2.y[n6]) - Camera.actualY0) * Camera.actualZoom) - mouseEvent.getY()) * n5;
                if (n8 < n) {
                    this.selectedPointN = n3;
                    n = n8;
                }
                ++n4;
            }
            ++n3;
        }
        return n;
    }

    public int distanseToBorder(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(0);
        double d = shapePoint2.x[1];
        int n3 = (int)(Camera.screenX0 + (d - Camera.actualX0) * Camera.actualZoom) - n;
        double d2 = shapePoint2.y[1];
        int n4 = (int)(Camera.screenY0 + (d2 - Camera.actualY0) * Camera.actualZoom) - n2;
        int n5 = n3 * n3 + n4 * n4;
        shapePoint2 = (shapePoint)this.pointVector.elementAt(1);
        int n6 = this.pointVector.size();
        int n7 = 2;
        while (n7 <= n6) {
            int n8 = n7;
            if (n8 == n6) {
                n8 = 1;
            }
            shapePoint shapePoint3 = (shapePoint)this.pointVector.elementAt(n8);
            int n9 = 0;
            while (n9 < 64) {
                double d3 = Besye.point(n9, shapePoint2.x[1], shapePoint2.x[2], shapePoint3.x[0], shapePoint3.x[1]);
                n3 = (int)(Camera.screenX0 + (d3 - Camera.actualX0) * Camera.actualZoom) - n;
                double d4 = Besye.point(n9, shapePoint2.y[1], shapePoint2.y[2], shapePoint3.y[0], shapePoint3.y[1]);
                n4 = (int)(Camera.screenY0 + (d4 - Camera.actualY0) * Camera.actualZoom) - n2;
                int n10 = n3 * n3 + n4 * n4;
                n5 = Math.min(n5, n10);
                ++n9;
            }
            if (n5 == 0) break;
            shapePoint2 = shapePoint3;
            ++n7;
        }
        return n5;
    }

    public boolean intersect(Rectangle rectangle) {
        shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(1);
        int n = this.pointVector.size();
        Polygon polygon = new Polygon();
        int n2 = 2;
        while (n2 <= n) {
            int n3 = n2;
            if (n3 == n) {
                n3 = 1;
            }
            shapePoint shapePoint3 = (shapePoint)this.pointVector.elementAt(n3);
            int n4 = 0;
            while (n4 < 64) {
                double d;
                int n5;
                double d2 = Besye.point(n4, shapePoint2.x[1], shapePoint2.x[2], shapePoint3.x[0], shapePoint3.x[1]);
                int n6 = (int)(Camera.screenX0 + (d2 - Camera.actualX0) * Camera.actualZoom);
                if (rectangle.contains(n6, n5 = (int)(Camera.screenY0 + ((d = Besye.point(n4, shapePoint2.y[1], shapePoint2.y[2], shapePoint3.y[0], shapePoint3.y[1])) - Camera.actualY0) * Camera.actualZoom))) {
                    return true;
                }
                polygon.addPoint(n6, n5);
                ++n4;
            }
            shapePoint2 = shapePoint3;
            ++n2;
        }
        return polygon.contains(rectangle.x, rectangle.y);
    }

    public int pivotDistanse(MouseEvent mouseEvent) {
        shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(0);
        double d = shapePoint2.x[1];
        int n = (int)(Camera.screenX0 + (d - Camera.actualX0) * Camera.actualZoom) - mouseEvent.getX();
        double d2 = shapePoint2.y[1];
        int n2 = (int)(Camera.screenY0 + (d2 - Camera.actualY0) * Camera.actualZoom) - mouseEvent.getY();
        return n * n + n2 * n2;
    }

    public shapePoint selectVertex(MouseEvent mouseEvent) {
        shapePoint shapePoint2 = null;
        int n = Integer.MAX_VALUE;
        int n2 = this.pointVector.size();
        int n3 = this.selectedPointN;
        int n4 = 0;
        while (n4 < n2) {
            shapePoint shapePoint3 = (shapePoint)this.pointVector.elementAt(n4);
            int n5 = 2;
            if (n4 == n3) {
                n5 = 4;
            }
            int n6 = 1;
            while (n6 < n5) {
                int n7;
                int n8 = n6;
                if (n6 == 3) {
                    n8 = 0;
                }
                double d = shapePoint3.x[n8];
                int n9 = (int)(Camera.screenX0 + (d - Camera.actualX0) * Camera.actualZoom) - mouseEvent.getX();
                int n10 = n9 * n9 + (n7 = (int)(Camera.screenY0 + ((d = shapePoint3.y[n8]) - Camera.actualY0) * Camera.actualZoom) - mouseEvent.getY()) * n7;
                if (n10 < n) {
                    this.selectedPointN = n4;
                    iPoint = n8;
                    n = n10;
                    shapePoint2 = shapePoint3;
                }
                ++n6;
            }
            ++n4;
        }
        return shapePoint2;
    }

    public void move(double d, double d2, double d3, double d4, double d5) {
        int n = this.pointVector.size();
        int n2 = 0;
        while (n2 < n) {
            shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(n2);
            shapePoint2.move(d, d2, d3, d4, d5);
            ++n2;
        }
    }

    public void morf(double d, double d2, double d3, double d4, double d5) {
        int n = this.pointVector.size();
        int n2 = 0;
        while (n2 < n) {
            shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(n2);
            shapePoint2.morf(d, d2, d3, d4, d5);
            ++n2;
        }
    }

    public void resize(double d, double d2, double d3, double d4, double d5, double d6) {
        int n = this.pointVector.size();
        int n2 = 0;
        while (n2 < n) {
            shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(n2);
            shapePoint2.resize(d, d2, d3, d4, d5, d6);
            ++n2;
        }
    }

    public void skew(double d, double d2, double d3, double d4, double d5, double d6) {
        int n = this.pointVector.size();
        int n2 = 0;
        while (n2 < n) {
            shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(n2);
            shapePoint2.skew(d, d2, d3, d4, d5, d6);
            ++n2;
        }
    }

    public void rotate(double d, double d2, double d3, double d4) {
        int n = this.pointVector.size();
        int n2 = 0;
        while (n2 < n) {
            shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(n2);
            shapePoint2.rotate(d, d2, d3, d4);
            ++n2;
        }
    }

    void plotDraw(Graphics graphics, int n, int n2) {
        int n3 = drawPoint.size();
        if (n3 == 0) {
            return;
        }
        Point point = (Point)drawPoint.elementAt(n3 - 1);
        graphics.setColor(Color.orange);
        graphics.drawLine(point.x, point.y, n, n2);
        if (n3 < 2) {
            return;
        }
        graphics.setColor(Color.red);
        point = (Point)drawPoint.elementAt(0);
        int n4 = 1;
        while (n4 < n3) {
            Point point2 = (Point)drawPoint.elementAt(n4);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            point = point2;
            ++n4;
        }
    }

    public void startDraw(MouseEvent mouseEvent) {
        drawPoint.addElement(new Point(mouseEvent.getX(), mouseEvent.getY()));
        xlast = mouseEvent.getX();
        ylast = mouseEvent.getY();
    }

    public void continueDraw(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - xlast;
        int n2 = mouseEvent.getY() - ylast;
        if (n != 0 || n2 != 0) {
            drawPoint.addElement(new Point(mouseEvent.getX(), mouseEvent.getY()));
            xlast = mouseEvent.getX();
            ylast = mouseEvent.getY();
        }
    }

    public void finishDraw(MouseEvent mouseEvent) {
        shapePoint shapePoint2;
        Point point;
        int n = drawPoint.size();
        this.pointVector.removeAllElements();
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            point = (Point)drawPoint.elementAt(n2);
            d += (double)point.x;
            d2 += (double)point.y;
            ++n2;
        }
        point = (Point)drawPoint.elementAt(0);
        int n3 = point.x;
        n3 = (int)(Camera.actualX0 + ((double)n3 - Camera.screenX0) / Camera.actualZoom);
        int n4 = point.y;
        n4 = (int)(Camera.actualX0 + ((double)n4 - Camera.screenX0) / Camera.actualZoom);
        int n5 = (int)(d /= (double)n);
        n5 = (int)((Camera.actualX0 + ((double)n5 - Camera.screenX0) / Camera.actualZoom + (double)(2 * n3)) / 3.0);
        int n6 = (int)(d2 /= (double)n);
        n6 = (int)((Camera.actualY0 + ((double)n6 - Camera.screenY0) / Camera.actualZoom + (double)(2 * n4)) / 3.0);
        this.pointVector.addElement(new shapePoint(n5, n6 + 50, n5, n6, n5 + 50, n6));
        int n7 = 0;
        int n8 = n % 6;
        shapePoint shapePoint3 = shapePoint2 = new shapePoint();
        shapePoint shapePoint4 = new shapePoint();
        this.pointVector.addElement(shapePoint2);
        point = (Point)drawPoint.elementAt(n7);
        int n9 = point.x;
        double d3 = Camera.actualX0 + ((double)n9 - Camera.screenX0) / Camera.actualZoom;
        int n10 = point.y;
        double d4 = Camera.actualX0 + ((double)n10 - Camera.screenX0) / Camera.actualZoom;
        boolean bl = true;
        do {
            if (++n7 >= n) {
                n7 = n - 1;
                bl = false;
            }
            shapePoint4 = new shapePoint();
            this.pointVector.addElement(shapePoint4);
            point = (Point)drawPoint.elementAt(n7);
            int n11 = point.x;
            double d5 = Camera.actualX0 + ((double)n11 - Camera.screenX0) / Camera.actualZoom;
            int n12 = point.y;
            double d6 = Camera.actualX0 + ((double)n12 - Camera.screenX0) / Camera.actualZoom;
            n7 += 4;
            if (n8 > 0) {
                --n8;
                ++n7;
            }
            if (n7 >= n) {
                n7 = n - 2;
                bl = false;
            }
            point = (Point)drawPoint.elementAt(n7);
            int n13 = point.x;
            double d7 = Camera.actualX0 + ((double)n13 - Camera.screenX0) / Camera.actualZoom;
            int n14 = point.y;
            double d8 = Camera.actualX0 + ((double)n14 - Camera.screenX0) / Camera.actualZoom;
            if (++n7 >= n) {
                n7 = n - 1;
                bl = false;
            }
            point = (Point)drawPoint.elementAt(n7);
            int n15 = point.x;
            double d9 = Camera.actualX0 + ((double)n15 - Camera.screenX0) / Camera.actualZoom;
            int n16 = point.y;
            double d10 = Camera.actualX0 + ((double)n16 - Camera.screenX0) / Camera.actualZoom;
            Besye.x1 = d3 + 2.0 * (d5 - d3);
            Besye.x2 = d9 + 2.0 * (d7 - d9);
            shapePoint2.x[1] = d3;
            shapePoint2.x[2] = Besye.x1;
            shapePoint4.x[0] = Besye.x2;
            shapePoint4.x[1] = d9;
            Besye.x1 = d4 + 2.0 * (d6 - d4);
            Besye.x2 = d10 + 2.0 * (d8 - d10);
            shapePoint2.y[1] = d4;
            shapePoint2.y[2] = Besye.x1;
            shapePoint4.y[0] = Besye.x2;
            shapePoint4.y[1] = d10;
            d3 = d9;
            d4 = d10;
            shapePoint2 = shapePoint4;
        } while (bl);
        shapePoint4.x[2] = (shapePoint4.x[1] * 2.0 + shapePoint3.x[1]) / 3.0;
        shapePoint4.y[2] = (shapePoint4.y[1] * 2.0 + shapePoint3.y[1]) / 3.0;
        shapePoint3.x[0] = (shapePoint4.x[1] + 2.0 * shapePoint3.x[1]) / 3.0;
        shapePoint3.y[0] = (shapePoint4.y[1] + 2.0 * shapePoint3.y[1]) / 3.0;
        drawPoint.removeAllElements();
    }

    public void startPick(MouseEvent mouseEvent) {
        drawPoint.addElement(new Point(mouseEvent.getX(), mouseEvent.getY()));
        xlast = mouseEvent.getX();
        ylast = mouseEvent.getY();
    }

    public boolean continuePick(MouseEvent mouseEvent) {
        if (xlast == mouseEvent.getX() && ylast == mouseEvent.getY()) {
            this.finishPick(mouseEvent);
            return false;
        }
        drawPoint.addElement(new Point(mouseEvent.getX(), mouseEvent.getY()));
        xlast = mouseEvent.getX();
        ylast = mouseEvent.getY();
        return true;
    }

    public void finishPick(MouseEvent mouseEvent) {
        Point point;
        int n = drawPoint.size();
        this.pointVector.removeAllElements();
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            point = (Point)drawPoint.elementAt(n2);
            d += (double)point.x;
            d2 += (double)point.y;
            ++n2;
        }
        point = (Point)drawPoint.elementAt(0);
        int n3 = point.x;
        n3 = (int)(Camera.actualX0 + ((double)n3 - Camera.screenX0) / Camera.actualZoom);
        int n4 = point.y;
        n4 = (int)(Camera.actualX0 + ((double)n4 - Camera.screenX0) / Camera.actualZoom);
        int n5 = (int)(d /= (double)n);
        n5 = (int)((Camera.actualX0 + ((double)n5 - Camera.screenX0) / Camera.actualZoom + (double)(2 * n3)) / 3.0);
        int n6 = (int)(d2 /= (double)n);
        n6 = (int)((Camera.actualY0 + ((double)n6 - Camera.screenY0) / Camera.actualZoom + (double)(2 * n4)) / 3.0);
        this.pointVector.addElement(new shapePoint(n5, n6 + 50, n5, n6, n5 + 50, n6));
        int n7 = 0;
        do {
            int n8;
            int n9;
            if ((n9 = n7 - 1) < 0) {
                n9 = n - 1;
            }
            if ((n8 = n7 + 1) >= n) {
                n8 = 0;
            }
            Point point2 = (Point)drawPoint.elementAt(n9);
            Point point3 = (Point)drawPoint.elementAt(n7);
            Point point4 = (Point)drawPoint.elementAt(n8);
            shapePoint shapePoint2 = new shapePoint();
            int n10 = point2.x;
            shapePoint2.x[0] = Camera.actualX0 + ((double)n10 - Camera.screenX0) / Camera.actualZoom;
            n10 = point2.y;
            shapePoint2.y[0] = Camera.actualY0 + ((double)n10 - Camera.screenY0) / Camera.actualZoom;
            n10 = point3.x;
            shapePoint2.x[1] = Camera.actualX0 + ((double)n10 - Camera.screenX0) / Camera.actualZoom;
            n10 = point3.y;
            shapePoint2.y[1] = Camera.actualY0 + ((double)n10 - Camera.screenY0) / Camera.actualZoom;
            n10 = point4.x;
            shapePoint2.x[2] = Camera.actualX0 + ((double)n10 - Camera.screenX0) / Camera.actualZoom;
            n10 = point4.y;
            shapePoint2.y[2] = Camera.actualY0 + ((double)n10 - Camera.screenY0) / Camera.actualZoom;
            shapePoint2.x[0] = (shapePoint2.x[0] + 2.0 * shapePoint2.x[1]) / 3.0;
            shapePoint2.y[0] = (shapePoint2.y[0] + 2.0 * shapePoint2.y[1]) / 3.0;
            shapePoint2.x[2] = (shapePoint2.x[2] + 2.0 * shapePoint2.x[1]) / 3.0;
            shapePoint2.y[2] = (shapePoint2.y[2] + 2.0 * shapePoint2.y[1]) / 3.0;
            this.pointVector.addElement(shapePoint2);
        } while (++n7 < n);
        drawPoint.removeAllElements();
    }

    public void vMirror() {
        int n = this.pointVector.size();
        Vector<shapePoint> vector = new Vector<shapePoint>();
        double d = ((shapePoint)this.pointVector.elementAt((int)0)).x[1];
        shapePoint shapePoint2 = (shapePoint)this.pointVector.elementAt(0);
        vector.addElement(shapePoint2);
        int n2 = n - 1;
        while (n2 > 0) {
            shapePoint2 = (shapePoint)this.pointVector.elementAt(n2);
            shapePoint2.vMirror(d);
            vector.addElement(shapePoint2);
            --n2;
        }
        int n3 = 1;
        while (n3 < n) {
            this.pointVector.removeElementAt(n3);
            this.pointVector.insertElementAt((shapePoint)vector.elementAt(n3), n3);
            ++n3;
        }
    }

    void centerPivot() {
        shapePoint shapePoint2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MIN_VALUE;
        double d6 = Double.MIN_VALUE;
        int n = this.pointVector.size();
        int n2 = 1;
        while (n2 < n) {
            shapePoint2 = (shapePoint)this.pointVector.elementAt(n2);
            if (d3 > shapePoint2.x[1]) {
                d3 = shapePoint2.x[1];
            }
            if (d4 > shapePoint2.y[1]) {
                d4 = shapePoint2.y[1];
            }
            if (d5 < shapePoint2.x[1]) {
                d5 = shapePoint2.x[1];
            }
            if (d6 < shapePoint2.y[1]) {
                d6 = shapePoint2.y[1];
            }
            d += shapePoint2.x[1];
            d2 += shapePoint2.y[1];
            ++n2;
        }
        shapePoint2 = (shapePoint)this.pointVector.elementAt(0);
        shapePoint2.x[0] = d /= (double)(--n);
        shapePoint2.y[0] = d6;
        shapePoint2.x[1] = d;
        shapePoint2.y[1] = d2 /= (double)n;
        shapePoint2.x[2] = d5;
        shapePoint2.y[2] = d2;
    }

    static {
        drawPoint = new Vector();
    }
}

