/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.util.Observable;

class Camera
extends Observable {
    static double actualZoom = 1.0;
    static double actualX0 = 376.0;
    static double actualY0 = 288.0;
    static final int PAINT = 0;
    static final int SCETCH = 1;
    static final int WIRE = 2;
    static int mode;
    static int maxW;
    static int maxH;
    static double devScreenWidth;
    static double devScreenHeight;
    static double devScreenX0;
    static double devScreenY0;
    static double screenWidth;
    static double screenX0;
    static double screenY0;
    static boolean rubberMode;
    static boolean treeMode;
    static boolean onionMode;
    double timePosition;
    double cameraZoom = actualZoom / screenWidth;
    double cameraX0;
    double cameraY0;

    static void setDeviceScreen(int n, int n2) {
        devScreenWidth = n;
        devScreenHeight = n2;
        double d = devScreenWidth * 576.0 / 752.0;
        if ((int)d > n2) {
            d = n2;
            devScreenWidth = d * 752.0 / 576.0;
        }
        devScreenHeight = d;
        devScreenX0 = (double)n / 2.0;
        devScreenY0 = (double)n2 / 2.0;
    }

    static void setScreenSize(int n, int n2) {
        screenWidth = n;
        screenX0 = (double)n / 2.0;
        screenY0 = (double)n2 / 2.0;
    }

    static int getScreenWidth() {
        return (int)(2.0 * screenX0);
    }

    static int getScreenHeight() {
        return (int)(2.0 * screenY0);
    }

    Camera() {
        this.cameraZoom = actualZoom / screenWidth;
        this.cameraX0 = actualX0;
        this.cameraY0 = actualY0;
        this.timePosition = 0.5;
    }

    void setToDeviceScreen() {
        screenWidth = devScreenWidth;
        screenX0 = devScreenX0;
        screenY0 = devScreenY0;
        actualZoom = this.cameraZoom * screenWidth;
    }

    Camera(int n, int n2) {
        screenWidth = n;
        screenX0 = n / 2;
        screenY0 = n2 / 2;
        actualX0 = n / 2;
        actualY0 = n2 / 2;
        actualZoom = (double)n / 752.0;
        this.cameraZoom = actualZoom / screenWidth;
        this.cameraX0 = actualX0;
        this.cameraY0 = actualY0;
    }

    Camera(double d) {
        screenWidth = 752.0;
        screenX0 = 376.0;
        screenY0 = 288.0;
        actualX0 = 376.0;
        actualY0 = 288.0;
        actualZoom = 1.0;
        this.cameraZoom = actualZoom / screenWidth;
        this.cameraX0 = actualX0;
        this.cameraY0 = actualY0;
        this.timePosition = d;
    }

    Camera(double d, Camera camera, Camera camera2) {
        this.timePosition = d;
        if (camera == camera2) {
            this.cameraX0 = camera.cameraX0;
            this.cameraY0 = camera.cameraY0;
            this.cameraZoom = camera.cameraZoom;
            return;
        }
        double d2 = (d - camera.timePosition) / (camera2.timePosition - camera.timePosition);
        this.cameraX0 = Besye.value(d2, camera.cameraX0, camera.cameraX0, camera2.cameraX0, camera2.cameraX0);
        this.cameraY0 = Besye.value(d2, camera.cameraY0, camera.cameraY0, camera2.cameraY0, camera2.cameraY0);
        this.cameraZoom = Besye.value(d2, camera.cameraZoom, camera.cameraZoom, camera2.cameraZoom, camera2.cameraZoom);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(new Color(10, 40, 10));
        int n = (int)(screenX0 + (0.0 - actualX0) * actualZoom);
        int n2 = (int)(screenY0 + (0.0 - actualY0) * actualZoom);
        int n3 = (int)(752.0 * actualZoom) - 1;
        int n4 = (int)(576.0 * actualZoom) - 1;
        int n5 = n4 / 5;
        graphics.drawRect(n, n2, n3, n4);
        graphics.drawRoundRect(n + n5 / 2, n2 + n5 / 2, n3 - n5, n4 - n5, n5, n5);
    }

    public void paintWork(Graphics graphics) {
        graphics.setColor(new Color(60, 140, 60));
        int n = (int)(-this.cameraX0 * this.cameraZoom);
        int n2 = (int)(-this.cameraY0 * this.cameraZoom);
        int n3 = (int)(2.0 * this.cameraX0 * this.cameraZoom);
        int n4 = (int)(2.0 * this.cameraY0 * this.cameraZoom);
        int n5 = n4 / 5;
        graphics.drawRect(n, n2, n3, n4);
        graphics.drawRoundRect(n + n5 / 2, n2 + n5 / 2, n3 - n5, n4 - n5, n5, n5);
    }

    public void zoom(boolean bl) {
        actualZoom = bl ? (actualZoom *= 2.0) : (actualZoom /= 2.0);
        this.get();
    }

    public void zoom(int n, int n2, int n3, int n4) {
        int n5 = n + n3 / 2;
        actualX0 += ((double)n5 - screenX0) / actualZoom;
        n5 = n2 + n4 / 2;
        actualY0 += ((double)n5 - screenY0) / actualZoom;
        actualZoom *= screenWidth / (double)n3;
        this.get();
    }

    public void zoom(int n, int n2, double d) {
        actualX0 += ((double)n - screenX0) / actualZoom;
        actualY0 += ((double)n2 - screenY0) / actualZoom;
        actualZoom *= d;
        this.get();
    }

    public void selectZoom(int n, int n2, double d) {
        actualX0 += (double)n / (actualZoom *= d);
        actualY0 += (double)n2 / actualZoom;
        this.get();
    }

    public void zoomReset() {
        screenWidth = devScreenWidth;
        screenX0 = devScreenX0;
        screenY0 = devScreenY0;
        actualX0 = 376.0;
        actualY0 = 288.0;
        actualZoom = devScreenWidth / 752.0;
        this.cameraZoom = actualZoom / screenWidth;
        this.cameraX0 = actualX0;
        this.cameraY0 = actualY0;
        this.get();
    }

    public void set() {
        actualX0 = this.cameraX0;
        actualY0 = this.cameraY0;
        actualZoom = this.cameraZoom * screenWidth;
    }

    public void get() {
        this.cameraX0 = actualX0;
        this.cameraY0 = actualY0;
        this.cameraZoom = actualZoom / screenWidth;
    }

    public static int xToScreen(double d) {
        return (int)(screenX0 + (d - actualX0) * actualZoom);
    }

    public static int yToScreen(double d) {
        return (int)(screenY0 + (d - actualY0) * actualZoom);
    }

    public static double xToWorld(int n) {
        return actualX0 + ((double)n - screenX0) / actualZoom;
    }

    public static double yToWorld(int n) {
        return actualY0 + ((double)n - screenY0) / actualZoom;
    }

    public static void setMode(int n) {
        mode = n;
    }

    public static int getMode() {
        return mode;
    }

    void tell() {
        this.setChanged();
        this.notifyObservers(this);
    }

    static {
        maxW = 752;
        maxH = 576;
        devScreenWidth = 752.0;
        devScreenHeight = 576.0;
        devScreenX0 = 376.0;
        devScreenY0 = 288.0;
        screenWidth = 752.0;
        screenX0 = 376.0;
        screenY0 = 288.0;
        treeMode = true;
        onionMode = true;
    }
}

