/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class AiFormat {
    static final byte SAME = 0;
    static final byte DIFF = 1;
    static final int READY = 0;
    static final int WORK = 1;
    static final int ERR = 2;
    GUI frame;
    InputStreamReader isr;
    BufferedReader br;
    BufferedWriter bw;
    Vector hdrVec;
    Vector kadrVec;
    Film film;
    Film updatedFilm;
    String fileName;
    String strBuf;
    double xbound;
    double ybound;

    public AiFormat(GUI gUI) {
        this.frame = gUI;
    }

    public String importAi(String string, Film film) {
        FileDialog fileDialog = new FileDialog((Frame)this.frame, "Ai import");
        fileDialog.setMode(0);
        ((Component)fileDialog).setLocation(200, 200);
        fileDialog.setDirectory(string);
        fileDialog.setFile("*.ai");
        ((Component)fileDialog).setVisible(true);
        string = fileDialog.getDirectory();
        if (fileDialog.getFile() == null) {
            return string;
        }
        this.fileName = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
        try {
            try {
                this.br = new BufferedReader(new InputStreamReader(new FileInputStream(this.fileName)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                new errMessage(this.frame, "ERROR|" + this.fileName + "|NOT Found");
                return string;
            }
            this.film = film;
            this.hdrVec = this.film.headerVec;
            this.kadrVec = this.film.kadrVec;
            this.execImportAi();
            this.br.close();
        }
        catch (IOException iOException) {
            new errMessage(this.frame, "ERROR open instream");
        }
        return string;
    }

    boolean execImportAi() {
        shapeHeader shapeHeader2 = new shapeHeader();
        ChShape chShape = new ChShape();
        shapeHeader shapeHeader3 = null;
        chShape.pointVector.addElement(new shapePoint());
        String[] stringArray = new String[16];
        shapePoint shapePoint2 = new shapePoint();
        int n = 0;
        boolean bl = false;
        try {
            block19: while ((this.strBuf = this.br.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.strBuf, " :\t");
                int n2 = stringTokenizer.countTokens();
                n = 0;
                int n3 = 0;
                while (n3 < n2) {
                    char c;
                    String string = stringTokenizer.nextToken();
                    if (string.startsWith("%%BoundingBox")) {
                        string = stringTokenizer.nextToken();
                        this.xbound = Double.valueOf(string);
                        string = stringTokenizer.nextToken();
                        string = stringTokenizer.nextToken();
                        string = stringTokenizer.nextToken();
                        this.ybound = Double.valueOf(string);
                        continue block19;
                    }
                    if (string.startsWith("%%EndSetup")) {
                        bl = true;
                    }
                    if (!bl || (c = string.charAt(0)) == '%') continue block19;
                    if (n3 < n2 - 1) {
                        stringArray[n++] = string;
                    } else {
                        int n4;
                        int n5;
                        int n6;
                        int n7;
                        double d;
                        double d2;
                        double d3;
                        n = 0;
                        if (string.equals("XA") || string.equals("Xa")) {
                            d3 = Double.valueOf(stringArray[0]);
                            d2 = Double.valueOf(stringArray[1]);
                            d = Double.valueOf(stringArray[2]);
                            n7 = string.charAt(1);
                            n6 = (int)(255.0 * d3);
                            n5 = (int)(255.0 * d2);
                            n4 = (int)(255.0 * d);
                            Color color = new Color(n6, n5, n4);
                            if (n7 == 97) {
                                shapeHeader2.fillColor = color;
                                continue block19;
                            }
                            shapeHeader2.borderColor = color;
                            continue block19;
                        }
                        if (string.length() > 1) continue block19;
                        switch (c) {
                            case 'w': {
                                shapeHeader2.bWidth = (int)Double.valueOf(stringArray[0]).doubleValue();
                                break;
                            }
                            case 'L': 
                            case 'l': 
                            case 'm': {
                                double d4 = this.getX(stringArray[0]);
                                double d5 = this.getY(stringArray[1]);
                                shapePoint2 = new shapePoint(d4, d5, d4, d5, d4, d5);
                                chShape.pointVector.addElement(shapePoint2);
                                break;
                            }
                            case 'V': 
                            case 'v': {
                                double d6 = this.getX(stringArray[0]);
                                double d7 = this.getY(stringArray[1]);
                                double d8 = this.getX(stringArray[2]);
                                double d9 = this.getY(stringArray[3]);
                                shapePoint2 = new shapePoint(d6, d7, d8, d9, d8, d9);
                                chShape.pointVector.addElement(shapePoint2);
                                break;
                            }
                            case 'Y': 
                            case 'y': {
                                double d10 = this.getX(stringArray[0]);
                                double d11 = this.getY(stringArray[1]);
                                double d8 = this.getX(stringArray[2]);
                                double d9 = this.getY(stringArray[3]);
                                shapePoint2.x[2] = d10;
                                shapePoint2.y[2] = d11;
                                shapePoint2 = new shapePoint(d8, d9, d8, d9, d8, d9);
                                chShape.pointVector.addElement(shapePoint2);
                                break;
                            }
                            case 'C': 
                            case 'c': {
                                double d10 = this.getX(stringArray[0]);
                                double d11 = this.getY(stringArray[1]);
                                double d6 = this.getX(stringArray[2]);
                                double d7 = this.getY(stringArray[3]);
                                double d8 = this.getX(stringArray[4]);
                                double d9 = this.getY(stringArray[5]);
                                shapePoint2.x[2] = d10;
                                shapePoint2.y[2] = d11;
                                shapePoint2 = new shapePoint(d6, d7, d8, d9, d8, d9);
                                chShape.pointVector.addElement(shapePoint2);
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                n7 = (int)(255.0 * Double.valueOf(stringArray[0]));
                                if (c == 'g') {
                                    shapeHeader2.fillColor = new Color(n7, n7, n7);
                                    break;
                                }
                                shapeHeader2.borderColor = new Color(n7, n7, n7);
                                break;
                            }
                            case 'K': 
                            case 'k': {
                                d3 = Double.valueOf(stringArray[0]);
                                d2 = Double.valueOf(stringArray[1]);
                                d = Double.valueOf(stringArray[2]);
                                double d12 = Double.valueOf(stringArray[3]);
                                double d13 = 1.0 - d12;
                                n6 = (int)(255.0 * (1.0 - Math.min(1.0, d3 * d13 + d12)));
                                n5 = (int)(255.0 * (1.0 - Math.min(1.0, d2 * d13 + d12)));
                                n4 = (int)(255.0 * (1.0 - Math.min(1.0, d * d13 + d12)));
                                if (c == 'k') {
                                    shapeHeader2.fillColor = new Color(n6, n5, n4);
                                    break;
                                }
                                shapeHeader2.borderColor = new Color(n6, n5, n4);
                                break;
                            }
                            case 'X': 
                            case 'x': {
                                d3 = Double.valueOf(stringArray[0]);
                                d2 = Double.valueOf(stringArray[1]);
                                d = Double.valueOf(stringArray[2]);
                                double d12 = Double.valueOf(stringArray[3]);
                                double d13 = 1.0 - d12;
                                n6 = (int)(255.0 * (1.0 - Math.min(1.0, d3 * d13 + d12)));
                                n5 = (int)(255.0 * (1.0 - Math.min(1.0, d2 * d13 + d12)));
                                n4 = (int)(255.0 * (1.0 - Math.min(1.0, d * d13 + d12)));
                                if (c == 'x') {
                                    shapeHeader2.fillColor = new Color(n6, n5, n4);
                                    break;
                                }
                                shapeHeader2.borderColor = new Color(n6, n5, n4);
                                break;
                            }
                            case 'B': 
                            case 'F': 
                            case 'N': 
                            case 'S': 
                            case 'b': 
                            case 'f': 
                            case 'n': 
                            case 's': {
                                shapeHeader2.setClosed(Character.isLowerCase(c));
                                char c2 = Character.toLowerCase(c);
                                switch (c2) {
                                    case 'f': {
                                        shapeHeader2.filled = true;
                                        shapeHeader2.bordered = false;
                                        break;
                                    }
                                    case 's': {
                                        shapeHeader2.filled = false;
                                        shapeHeader2.bordered = true;
                                        break;
                                    }
                                    case 'b': {
                                        shapeHeader2.filled = true;
                                        shapeHeader2.bordered = true;
                                        break;
                                    }
                                    case 'n': {
                                        shapeHeader2.filled = false;
                                        shapeHeader2.bordered = false;
                                    }
                                }
                                this.film.headerVec.addElement(shapeHeader2);
                                if (shapeHeader3 == null) {
                                    shapeHeader3 = shapeHeader2;
                                } else {
                                    shapeHeader2.mammy = shapeHeader3;
                                }
                                shapeHeader2 = new shapeHeader();
                                chShape.centerPivot();
                                int n8 = 0;
                                while (n8 < this.kadrVec.size()) {
                                    Kadr kadr = (Kadr)this.film.kadrVec.elementAt(n8);
                                    ChShape chShape2 = new ChShape(chShape);
                                    kadr.shapeVector.addElement(chShape2);
                                    ++n8;
                                }
                                chShape = new ChShape();
                                chShape.pointVector.addElement(new shapePoint());
                            }
                        }
                    }
                    ++n3;
                }
            }
            this.film.tell();
        }
        catch (IOException iOException) {
            new errMessage(this.frame, "ERROR reading object");
            return false;
        }
        return true;
    }

    double getX(String string) {
        return Double.valueOf(string) - this.xbound;
    }

    double getY(String string) {
        return this.ybound - Double.valueOf(string);
    }

    public String exportAi(String string, Film film) {
        FileDialog fileDialog = new FileDialog((Frame)this.frame, "Ai import");
        fileDialog.setMode(1);
        ((Component)fileDialog).setLocation(200, 200);
        fileDialog.setDirectory(string);
        fileDialog.setFile("*.ai");
        ((Component)fileDialog).setVisible(true);
        string = fileDialog.getDirectory();
        if (fileDialog.getFile() == null) {
            return string;
        }
        this.fileName = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
        try {
            try {
                this.bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.fileName)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                new errMessage(this.frame, "ERROR|" + this.fileName + "|NOT Found");
                return string;
            }
            this.film = film;
            this.hdrVec = this.film.headerVec;
            this.kadrVec = this.film.kadrVec;
            this.execExportAi();
        }
        catch (IOException iOException) {
            new errMessage(this.frame, "ERROR open outstream");
        }
        return string;
    }

    void execExportAi() {
        try {
            this.bw.write("%!PS-Adobe-3.0 \n");
            this.bw.write("%%BoundingBox: -11 183 581 629\n");
            this.bw.write("%%DocumentProcessColors: Cyan Magenta Yellow\n");
            this.bw.write("%%DocumentNeededResources: procset Adobe_packedarray 2.0 0\n");
            this.bw.write("%%+ procset Adobe_cmykcolor 1.1 0\n");
            this.bw.write("%%+ procset Adobe_cshow 1.1 0\n");
            this.bw.write("%%+ procset Adobe_customcolor 1.0 0\n");
            this.bw.write("%%+ procset Adobe_IllustratorA_AI3 1.0 1\n");
            this.bw.write("%AI3_ColorUsage: Color\n");
            this.bw.write("%AI3_Cropmarks: -80 130 640 670\n");
            this.bw.write("%AI3_TemplateBox: 285 406 285 406\n");
            this.bw.write("%AI3_TileBox: -80 130 640 670\n");
            this.bw.write("%AI3_DocumentPreview: None\n");
            this.bw.write("%%PageOrigin:-121 125\n");
            this.bw.write("%%AI3_PaperRect:-14 581 828 -14\n");
            this.bw.write("%%AI3_Margin:14 -14 -18 14\n");
            this.bw.write("%AI7_GridSettings: 72 8 72 8 1 0 0.8 0.8 0.8 0.9 0.9 0.9\n");
            this.bw.write("%%EndComments\n");
            this.bw.write("%%BeginProlog\n");
            this.bw.write("%%IncludeResource: procset Adobe_packedarray 2.0 0\n");
            this.bw.write("Adobe_packedarray /initialize get exec\n");
            this.bw.write("%%IncludeResource: procset Adobe_cmykcolor 1.1 0\n");
            this.bw.write("%%IncludeResource: procset Adobe_cshow 1.1 0\n");
            this.bw.write("%%IncludeResource: procset Adobe_customcolor 1.0 0\n");
            this.bw.write("%%IncludeResource: procset Adobe_IllustratorA_AI3 1.0 1\n");
            this.bw.write("%%EndProlog\n");
            this.bw.write("%%BeginSetup\n");
            this.bw.write("Adobe_cmykcolor /initialize get exec\n");
            this.bw.write("Adobe_cshow /initialize get exec\n");
            this.bw.write("Adobe_customcolor /initialize get exec\n");
            this.bw.write("Adobe_IllustratorA_AI3 /initialize get exec\n");
            this.bw.write("%%EndSetup\n");
            this.bw.write("0 A\n");
            this.bw.write("0 O\n");
            this.bw.write("0 i\n");
            this.bw.write("1 J 1 j 1 w 4 M []0 d\n");
            this.bw.write("%AI3_Note:\n");
            this.bw.write("0 D\n");
            Camera.screenWidth = 720.0;
            Camera.screenX0 = 360.0;
            Camera.screenY0 = 270.0;
            Camera camera = this.film.tmpCamera(this.film.framePosition(this.film.selectedKadrN), 0.0);
            camera.set();
            Kadr kadr = (Kadr)this.film.kadrVec.elementAt(this.film.selectedKadrN);
            Vector vector = kadr.shapeVector;
            int n = 0;
            while (n < this.film.headerVec.size()) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                shapePoint shapePoint2;
                int n7;
                int n8;
                ChShape chShape;
                double d;
                double d2;
                double d3;
                Color color;
                shapeHeader shapeHeader2 = (shapeHeader)this.film.headerVec.elementAt(n);
                if (shapeHeader2.getFilled()) {
                    color = shapeHeader2.fillColor;
                    d3 = 1.0 - (double)color.getRed() / 255.0;
                    d2 = 1.0 - (double)color.getGreen() / 255.0;
                    d = 1.0 - (double)color.getBlue() / 255.0;
                    double d4 = Math.min(d3, d2);
                    d4 = Math.min(d4, d);
                    this.bw.write(String.valueOf(d3 -= (d4 /= 2.0)) + " " + (d2 -= d4) + " " + (d -= d4) + " " + d4 + " k\n");
                    chShape = (ChShape)vector.elementAt(n);
                    n8 = 1;
                    while (n8 < chShape.pointVector.size()) {
                        int n9;
                        n7 = n8 + 1;
                        if (n7 == chShape.pointVector.size()) {
                            n7 = 1;
                        }
                        shapePoint shapePoint3 = (shapePoint)chShape.pointVector.elementAt(n8);
                        shapePoint2 = (shapePoint)chShape.pointVector.elementAt(n7);
                        if (n8 == 1) {
                            n9 = this.xtoAI(shapePoint3.x[1]);
                            n6 = this.ytoAI(shapePoint3.y[1]);
                            this.bw.write(String.valueOf(n9) + " " + n6 + " m\n");
                        }
                        n9 = this.xtoAI(shapePoint3.x[2]);
                        n6 = this.ytoAI(shapePoint3.y[2]);
                        n5 = this.xtoAI(shapePoint2.x[0]);
                        n4 = this.ytoAI(shapePoint2.y[0]);
                        n3 = this.xtoAI(shapePoint2.x[1]);
                        n2 = this.ytoAI(shapePoint2.y[1]);
                        this.bw.write(String.valueOf(n9) + " " + n6 + " " + n5 + " " + n4 + " " + n3 + " " + n2 + " C\n");
                        ++n8;
                    }
                    this.bw.write("f\n");
                }
                if (shapeHeader2.getBordered()) {
                    color = shapeHeader2.borderColor;
                    d3 = 1.0 - (double)color.getRed() / 255.0;
                    d2 = 1.0 - (double)color.getGreen() / 255.0;
                    d = 1.0 - (double)color.getBlue() / 255.0;
                    this.bw.write(String.valueOf(d3) + " " + d2 + " " + d + " 0 K\n");
                    this.bw.write(String.valueOf((double)shapeHeader2.bWidth * Camera.actualZoom) + " w\n");
                    chShape = (ChShape)vector.elementAt(n);
                    n8 = chShape.pointVector.size();
                    if (!shapeHeader2.getClosed()) {
                        --n8;
                    }
                    n7 = 1;
                    while (n7 < n8) {
                        int n10 = n7 + 1;
                        if (n10 == chShape.pointVector.size()) {
                            n10 = 1;
                        }
                        shapePoint2 = (shapePoint)chShape.pointVector.elementAt(n7);
                        shapePoint shapePoint4 = (shapePoint)chShape.pointVector.elementAt(n10);
                        if (n7 == 1) {
                            n6 = this.xtoAI(shapePoint2.x[1]);
                            n5 = this.ytoAI(shapePoint2.y[1]);
                            this.bw.write(String.valueOf(n6) + " " + n5 + " m\n");
                        }
                        n6 = this.xtoAI(shapePoint2.x[2]);
                        n5 = this.ytoAI(shapePoint2.y[2]);
                        n4 = this.xtoAI(shapePoint4.x[0]);
                        n3 = this.ytoAI(shapePoint4.y[0]);
                        n2 = this.xtoAI(shapePoint4.x[1]);
                        int n11 = this.ytoAI(shapePoint4.y[1]);
                        this.bw.write(String.valueOf(n6) + " " + n5 + " " + n4 + " " + n3 + " " + n2 + " " + n11 + " C\n");
                        ++n7;
                    }
                    this.bw.write("S\n");
                }
                ++n;
            }
            this.bw.write("%%PageTrailer\n");
            this.bw.write("gsave annotatepage grestore showpage\n");
            this.bw.write("%%Trailer\n");
            this.bw.write("Adobe_IllustratorA_AI3 /terminate get exec\n");
            this.bw.write("Adobe_customcolor /terminate get exec\n");
            this.bw.write("Adobe_cshow /terminate get exec\n");
            this.bw.write("Adobe_cmykcolor /terminate get exec\n");
            this.bw.write("Adobe_packedarray /terminate get exec\n");
            this.bw.write("%%EOF\n");
            this.bw.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    int xtoAI(double d) {
        return -80 + (int)(Camera.screenX0 + (d - Camera.actualX0) * Camera.actualZoom);
    }

    int ytoAI(double d) {
        return 670 - (int)(Camera.screenY0 + (d - Camera.actualY0) * Camera.actualZoom);
    }
}

